% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_historicals.R
\name{get_historicals}
\alias{get_historicals}
\title{Get historical price history from RobinHood}
\usage{
get_historicals(RH, symbol, interval, span, tz = Sys.timezone())
}
\arguments{
\item{RH}{object of class RobinHood}

\item{symbol}{(string) Stock symbol to query, single symbol only}

\item{interval}{(string) Interval of time to aggregate to (examples: hour, day, week, month)}

\item{span}{(string) Period of time you are interested in (examples: day, week, month, year)}

\item{tz}{(string) timezone returned by OlsonNames() (eg: "America/Chicago")}
}
\description{
Returns a data frame of historical price history for a given symbol.
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

get_historicals(RH = RH, symbol = "CAT", interval = "day", span = "month")

}
}
