% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiBMA.R
\name{BiBMA}
\alias{BiBMA}
\title{Estimate a Bayesian Model-Averaged Meta-Analysis of Binomial Data}
\usage{
BiBMA(
  x1,
  x2,
  n1,
  n2,
  study_names = NULL,
  study_ids = NULL,
  priors_effect = prior(distribution = "student", parameters = list(location = 0, scale =
    0.58, df = 4)),
  priors_heterogeneity = prior(distribution = "invgamma", parameters = list(shape = 1.77,
    scale = 0.55)),
  priors_effect_null = prior(distribution = "point", parameters = list(location = 0)),
  priors_heterogeneity_null = prior(distribution = "point", parameters = list(location =
    0)),
  priors_baseline = NULL,
  priors_baseline_null = prior_factor("beta", parameters = list(alpha = 1, beta = 1),
    contrast = "independent"),
  chains = 3,
  sample = 5000,
  burnin = 2000,
  adapt = 500,
  thin = 1,
  parallel = FALSE,
  autofit = TRUE,
  autofit_control = set_autofit_control(),
  convergence_checks = set_convergence_checks(),
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{x1}{a vector with the number of successes in the first group}

\item{x2}{a vector with the number of successes in the second group}

\item{n1}{a vector with the number of observations in the first group}

\item{n2}{a vector with the number of observations in the second group}

\item{study_names}{an optional argument with the names of the studies}

\item{study_ids}{an optional argument specifying dependency between the
studies (for using a multilevel model). Defaults to \code{NULL} for
studies being independent.}

\item{priors_effect}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "student",   parameters = list(location = 0, scale = 0.58, df = 4))},
based on logOR meta-analytic estimates from the Cochrane Database of Systematic Reviews
\insertCite{bartos2023empirical}{RoBMA}.}

\item{priors_heterogeneity}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "invgamma",  parameters = list(shape = 1.77, scale = 0.55))} that
is based on heterogeneities of logOR estimates from the Cochrane Database of Systematic Reviews
\insertCite{bartos2023empirical}{RoBMA}.}

\item{priors_effect_null}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero,
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_heterogeneity_null}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero (a fixed effect meta-analytic models),
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_baseline}{prior distributions for the alternative hypothesis about
intercepts (\code{pi}) of each study. Defaults to \code{NULL}.}

\item{priors_baseline_null}{prior distributions for the null hypothesis about
intercepts (\code{pi}) for each study. Defaults to an independent uniform prior distribution
for each intercept \code{prior("beta", parameters = list(alpha = 1, beta = 1), contrast = "independent")}.}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{sample}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{burnin}{a number of burnin iterations of the MCMC algorithm.
Defaults to \code{2000}.}

\item{adapt}{a number of adaptation iterations of the MCMC algorithm.
Defaults to \code{500}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{autofit}{whether the model should be fitted until the convergence
criteria (specified in \code{autofit_control}) are satisfied. Defaults to
\code{TRUE}.}

\item{autofit_control}{allows to pass autofit control settings with the
\code{\link[=set_autofit_control]{set_autofit_control()}} function. See \code{?set_autofit_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{NoBMA} returns an object of class 'RoBMA'.
}
\description{
\code{BiBMA} estimate a Binomial Bayesian
model-averaged meta-analysis. The interface allows a complete customization of
the ensemble with different prior (or list of prior) distributions
for each component.
}
\details{
See \code{\link[=RoBMA]{RoBMA()}} for more details.
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}, \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=update.RoBMA]{update.RoBMA()}}, \code{\link[=check_setup]{check_setup()}}
}
