% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlperiod.R
\name{validNlPeriods}
\alias{validNlPeriods}
\title{Check if an nlPeriod is valid for a given nightlight type}
\usage{
validNlPeriods(nlPeriods, nlTypes)
}
\arguments{
\item{nlPeriods}{the nlPeriods of interest}

\item{nlTypes}{type of nightlight}
}
\value{
named logical list of TRUE/FALSE
}
\description{
Check if an nlPeriod is valid for a given nightlight type. Vectorized
    to allow checking multiple nlPeriods of corresponding nlTypes. If
    a single nlType is given all nlPeriods are checked in that nlType.
    If multiple nlTypes are given, then a corresponding number of
    nlPeriods is expected e.g. if nlPeriods is a vector each entry
    must correspond to the nlType. If multiple nlPeriods are to be 
    tested per nlType then a list of vectors is expected, one for
    each nlType.
}
\examples{
validNlPeriods(c("201401", "201402"),"VIIRS.M")
 #returns
 #$VIIRS.M
 #201401 201402 
 #  TRUE   TRUE

validNlPeriods("201203","VIIRS.M")
 #returns FALSE

validNlPeriods("2012","OLS.Y")
 #returns TRUE

}
