% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{getCtryNlDataColName}
\alias{getCtryNlDataColName}
\title{Construct the name of a nightlight data column given the nightlight type and nlPeriod}
\usage{
getCtryNlDataColName(nlPeriod, stat, nlType)
}
\arguments{
\item{nlPeriod}{character vector The nlPeriod to process}

\item{stat}{character vector The stat to be stored in the column}

\item{nlType}{character vector The type of nightlight i.e. "OLS" or VIIRS. Default=VIIRS}
}
\value{
character string
}
\description{
Construct the name of a nightlight data column given the nightlight type and nlPeriod Used in
    creating and retrieving data columns from the nightlight data file
}
\examples{
\dontrun{
ctryCode <- "KEN"
dt <- read.csv(getCtryNlDataFnamePath(ctryCode))
dt <- dt[,getCtryNlDataColName("201612", "sum", nlType="VIIRS")]
  #returns the column "NL_201612_SUM" if it exists in the KEN data file
  }
}
