% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{rnetBasic-class}
\alias{rnetBasic-class}
\alias{rnetBasic}
\title{An S4 class containg the information of a basic rnet. These objects are used to handle rnet objects and need not be called by the user.}
\description{
Inherits from 'rnetInput'
}
\section{Slots}{

\describe{
\item{\code{x}}{A dataframe containing the dataset.}

\item{\code{L1}}{The L1 penalty}

\item{\code{vertices}}{The vertex set}

\item{\code{n}}{A square matrix of n_ij, the number of valid pairs used to estimate the edge between i and j.}

\item{\code{V_omitted}}{The names of vertices removed from the rnet due to low sample size or forced to 0.}

\item{\code{V_metadata}}{A Vector containing the attribute names assigned to the rnet's vertices.}

\item{\code{E_metadata}}{A vector containing the attribute names assinged to the rnet's edges.}

\item{\code{zeros}}{A list of edges forced to zero due to small sample size or declared by user.}

\item{\code{Sigma}}{The empirical correlation matrix}

\item{\code{Theta}}{The penalized precision matrix (Sigma^-1)}

\item{\code{Omega}}{The penalized partial correlation matrix. Also the weighted adajacency matrix used for the network.}

\item{\code{A}}{The adjacency matrix (omega_ij != 0)}

\item{\code{R}}{An igraph object derived from Omega}

\item{\code{layout}}{A k' x 2 matrix containing the x & y coords for the vertices for plotting. k' indicates that some of the k vertices declared may have been removed, typically due to a variable having fewer than n_min observations.}
}}

