% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest}
\alias{nest}
\title{Nest Eigenvalue Sufficiency Test (NEST)}
\usage{
nest(
  data,
  n = NULL,
  nrep = 1000,
  alpha = 0.05,
  max.fact = ncol(data),
  method = "ml",
  na.action = "fiml",
  ...
)
}
\arguments{
\item{data}{A data frame, a numeric matrix, covariance matrix or correlation matrix from which to determine the number of factors.}

\item{n}{The number of cases (subjects, participants, or units) if a covariance matrix is supplied in \code{data}.}

\item{nrep}{The number of replications to simulate. Default is 1000.}

\item{alpha}{A vector of type I error rates or \code{(1-alpha)*100\%} confidence intervals. Default is .05.}

\item{max.fact}{An optional maximum number of factor to extract. Default is \code{max.fact = ncol(data)}.}

\item{method}{A method used to compute loadings and uniquenesses. Four methods are implemented in \code{Rnest} : maximum likelihood \code{method = "ml"} (default), regularized common factor analysis \code{method = "rcfa"}, minimum rank factor analysis \code{method = "mrfa"}, and principal axis factoring \code{method = "paf"}. See details for custom methods.}

\item{na.action}{How should missing data be removed. \code{"na.omit"} removes complete rows with at least one single missing data. \code{"fiml"} uses full information maximum likelihood to compute the correlation matrix. Other options are "everything", "all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs". Default is "fiml.}

\item{...}{Arguments for \code{method} that can be supplied. See details.}
}
\value{
\code{nest} returns an object of class \code{nest}. The functions \code{summary} and \code{plot} are used to obtain and show a summary of the results.

An object of class \code{nest} is a list containing the following components:

\itemize{
  \item \code{nfactors} - The number of factors to retains (one by \code{alpha}).
  \item \code{cor} - The supplied correlation matrix.
  \item \code{n} - The number of cases (subjects, participants, or units).
  \item \code{values} - The eigenvalues of the supplied correlation matrix.
  \item \code{alpha} - The type I error rate.
  \item \code{method} - The method used to compute loadings and uniquenesses.
  \item \code{nrep} - The number of replications used.
  \item \code{prob} - Probabilities of each factor.
  \item \code{Eig} - A list of simulated eigenvalues.
}
}
\description{
\code{nest} is used to identify the number of factors to retain in exploratory factor analysis.
}
\details{
The Next Eigenvalues Sufficiency Test (NEST) is an extension of parallel analysis by adding a sequential hypothesis testing procedure for every \eqn{k = 1, ..., p} factor until the hypothesis is not rejected. 

At \eqn{k = 1}, NEST and parallel analysis are identical. Both use an Identity matrix as the correlation matrix. Once the first hypothesis is rejected, NEST uses a correlation matrix based on the loadings and uniquenesses of the \eqn{k^{th}} factorial structure. NEST then resamples the eigenvalues of this new correlation matrix. NEST stops when the $k_1^2$ eigenvalues is within the confidence interval.  

There is two \code{method} already implemented in \code{nest} to extract loadings and uniquenesses: maximum likelihood (\code{"ml"}; default), principal axis factoring (\code{"paf"}), and minimum rank factor analysis (\code{"mrfa"}). The functions use as arguments: \code{covmat}, \code{n}, \code{factors}, and \code{...} (supplementary arguments passed by \code{nest}). They return \code{loadings} and \code{uniquenesses}. Any other user-defined functions can be used as long as it is programmed likewise.
}
\section{Generic function}{


\code{plot.nest} Scree plot of the eigenvalues and the simulated confidence intervals for \code{alpha}.

\code{loadings} Extract loadings. It does not overwrite \code{stat::loadings}.
}

\examples{
nest(ex_2factors, n = 100)
nest(mtcars)
}
\references{
Achim, A. (2017). Testing the number of required dimensions in exploratory factor analysis. \emph{The Quantitative Methods for Psychology}, \emph{13}(1), 64-74. \doi{10.20982/tqmp.13.1.p064}
}
\author{
P.-O. Caron
}
