% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixmodPredict.R
\docType{class}
\name{MixmodPredict-class}
\alias{MixmodPredict-class}
\title{Constructor of [\code{\linkS4class{MixmodPredict}}] class}
\description{
This is a class to run discriminant analysis with mixmod.
}
\details{
\describe{
  \item{data}{numeric vector, matrix, or data frame of observations. Either qualitative or quantitative.}
  \item{dataType}{character. It defines whether data are quantitative or qualitative.}
  \item{nbVariable}{integer. The number of variables.}
  \item{nbSample}{integer. The number of observations.}
  \item{error}{a character. The mixmod error.}
  \item{classificationRule}{a [\code{\linkS4class{MixmodResults}}] object containing the classification rule.}
  \item{partition}{a matrix containing observations to predict.}
  \item{proba}{a matrix of probabilities.}
}
}
\examples{
  # start by extract 10 observations from iris data set
  remaining.obs<-sample(1:nrow(iris),10)

  # then run a mixmodLearn() analysis without those 10 observations
  learn<-mixmodLearn(iris[-remaining.obs,1:4], iris$Species[-remaining.obs])
  # create a MixmodPredict to predict those 10 observations
  new("MixmodPredict", data=iris[remaining.obs,1:4], classificationRule=learn["bestResult"])

  getSlots("MixmodPredict")

}

