\name{mixmodCluster}
\alias{mixmodCluster}
\alias{mixmodCluster.default}
\title{Create an instance of the [\code{\linkS4class{MixmodCluster}}] class}
\usage{
mixmodCluster(...)
\method{mixmodCluster}{default}(data, nbCluster, dataType = NULL,
    models = NULL, strategy = mixmodStrategy(),
    criterion = "BIC", weight = NULL, knownLabels = NULL)
}
\arguments{
 \item{...}{The following arguments are accepted:}
  \item{data}{frame containing quantitative,qualitative or
  heterogeneous data. Rows correspond to observations and
  columns correspond to variables.}

  \item{nbCluster}{numeric listing the number of clusters.}

  \item{dataType}{character. Type of data is
  "quantitative", "qualitative" or "composite". Set as NULL
  by default, type will be guessed depending on variables
  type.}

  \item{models}{a [\code{\linkS4class{Model}}] object
  defining the list of models to run. For quantitative
  data, the model "Gaussian_pk_Lk_C" is called (see
  mixmodGaussianModel() to specify other models). For
  qualitative data, the model "Binary_pk_Ekjh" is called
  (see mixmodMultinomialModel() to specify other models).}

  \item{strategy}{a [\code{\linkS4class{Strategy}}] object
  containing the strategy to run. Call mixmodStrategy()
  method by default.}

  \item{criterion}{list of character defining the criterion
  to select the best model. The best model is the one with
  the lowest criterion value. Possible values: "BIC",
  "ICL", "NEC", c("BIC", "ICL", "NEC"). Default is "BIC".}

  \item{weight}{numeric vector with n (number of
  individuals) rows. Weight is optionnal. This option is to
  be used when weight is associated to the data.}

  \item{knownLabels}{vector of size nbSample. it will be
  used for semi-supervised classification when labels are
  known. Each cell corresponds to a cluster affectation.}

}
\value{
  Returns an instance of the
  [\code{\linkS4class{MixmodCluster}}] class. Those two
  attributes will contain all outputs: \describe{
  \item{results}{a list of
  [\code{\linkS4class{MixmodResults}}] object containing
  all the results sorted in ascending order according to
  the given criterion.} \item{bestResult}{a S4
  [\code{\linkS4class{MixmodResults}}] object containing
  the best model results.} }
  
}
\description{
  This function computes an optimal mixture model according
  to the criteria furnished, and the list of model defined
  in [\code{\linkS4class{Model}}], using the algorithm
  specified in [\code{\linkS4class{Strategy}}].
}
\examples{
## A quantitative example with the famous geyser data set
  data(geyser)
  ## with default values
  mixmodCluster(geyser, nbCluster=2:6)

  ## A qualitative example with the birds data set
  data(birds)
  mixmodCluster(data=birds, nbCluster = 2:5, criterion= c("BIC","ICL","NEC"),
                model = mixmodMultinomialModel())

  ## use graphics functions
  xem <- mixmodCluster(data=geyser, nbCluster=3)
  \dontrun{
  plot(xem)
  hist(xem)
  }

  ## get summary
  summary(xem)

  ## A composite example with a heterogeneous data set
  data(heterodata)
  mixmodCluster(heterodata,2)
}
\author{
  Florent Langrognet and Remi Lebret and Christian Poli and Serge Iovleff,
  with contributions from C. Biernacki and G. Celeux and G.
  Govaert \email{contact@mixmod.org}
}

