% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_gas_model.R
\name{mbal_perform_param_gas}
\alias{mbal_perform_param_gas}
\title{A list object of class 'mbal_gas' for material balance analysis}
\usage{
mbal_perform_param_gas(
  input_unit = "Field",
  output_unit = "Field",
  aquifer_model = NULL,
  G = NULL,
  phi = NULL,
  swi = NULL,
  Gp = NULL,
  Np = NULL,
  Wp = NULL,
  Wi = NULL,
  We = NULL,
  pd = NULL,
  p = NULL,
  pvt = NULL,
  cf = NULL,
  M = NULL,
  phi_a = NULL,
  perm_h_a = NULL,
  perm_v_a = NULL,
  h_a = NULL,
  r_a = NULL,
  r_R = NULL,
  w_a = NULL,
  l_a = NULL,
  tetha = NULL,
  muw_a = NULL,
  cw_a = NULL,
  cf_a = NULL,
  wf = NULL,
  sgrw = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, only the character string 'Field' is accepted}

\item{output_unit}{a unit system for properties, only the character string 'Field' is accepted}

\item{aquifer_model}{defaulted to \code{NULL}, otherwise must be a character string, one of the following eight options: 'uss_rad_edge', 'uss_rad_bottom', 'uss_lin_edge', 'uss_lin_bottom', 'pss_rad_edge', 'pss_lin_edge', 'pss_lin_bottom', 'pot'. For further information about each model, please see 'Raquifer' package reference manual (https://cran.r-project.org/web/packages/Raquifer/index.html)}

\item{G}{original gas in place, SCF.}

\item{phi}{reservoir porosity, a numeric fraction}

\item{swi}{initial water saturation in the reservoir, a numeric fraction}

\item{Gp}{cumulative gas production, SCF}

\item{Np}{cumulative oil production, STB}

\item{Wp}{cumulative water production, STB}

\item{Wi}{cumulative water injection, STB}

\item{We}{cumulative aquifer water influx, BBL. If unknown, a \code{NULL} value must be assigned}

\item{pd}{dew point pressure, a numeric value, psi}

\item{p}{reservoir pressure, a numeric vector, psi}

\item{pvt}{a data frame of PVT properties including pressure 'p' in 'psi', oil formation volume factor 'Bo' in 'bbl/stb', solution gas-oil ratio 'Rs' in 'scf/stb', oil viscosity 'muo' in 'cp', volatilized oil-gas ratio 'Rv' in 'stb/scf', gas formation volume factor 'Bg' in 'bbl/scf', gas viscosity 'mug' in 'cp', water formation volume factor 'Bw' in 'bbl/stb', and water viscosity 'muw' in 'cp'}

\item{cf}{formation compressibility, a numeric value or vector, 1/psi}

\item{M}{ratio of non-net-pay pore volume to the reservoir (net-pay) volume, a numeric fraction.}

\item{phi_a}{aquifer porosity, a numeric fraction}

\item{perm_h_a}{aquifer horizontal permeability, md. Used in 'uss_rad_edge', 'uss_rad_bottom', 'uss_lin_edge', 'pss_rad_edge', 'pss_lin_edge' and 'pot' aquifer models}

\item{perm_v_a}{vertical permeability, md. Used in 'uss_rad_bottom', 'uss_lin_bottom', 'pss_rad_bottom', and 'pss_lin_bottom' aquifer models}

\item{h_a}{aquifer height, ft}

\item{r_a}{aquifer radius, ft. Used in 'uss_rad_edge', 'uss_rad_bottom', 'pss_rad_edge', and 'pot' aquifer models}

\item{r_R}{reservoir radius, ft. Used in 'uss_rad_edge', 'uss_rad_bottom', 'pss_rad_edge', and 'pot' aquifer models}

\item{w_a}{aquifer width, ft. Used in 'uss_lin_edge', 'uss_lin_bottom', 'pss_lin_edge', and 'pss_lin_bottom' aquifer models}

\item{l_a}{aquifer length, ft. Used in 'uss_lin_edge', 'uss_lin_bottom', 'pss_lin_edge', and 'pss_lin_bottom' aquifer models}

\item{tetha}{fraction of reservoir encircled by the aquifer, degrees. Used in 'uss_rad_edge', 'pss_rad_edge', and 'pot' aquifer models}

\item{muw_a}{aquifer water viscosity, cp}

\item{cw_a}{aquifer water compressibility, a numeric value, 1/psi}

\item{cf_a}{aquifer formation compressibility, a numeric value, 1/psi}

\item{wf}{weight factor, a numeric vector of zeros and ones. A zero value excludes the entire row of reservoir history data at a particular time from the material balance analysis}

\item{sgrw}{residual gas saturation in water invaded zone (aquifer encroachment or water injection), a numeric fraction}
}
\value{
a list of class ’mbal_gas’ with all the required parameters for the mbal_perform_gas() S3 methods
}
\description{
Create an object of class 'mbal_gas'
}
\examples{
p_pvt <- c(3700, 3650, 3400, 3100, 2800, 2500, 2200, 1900, 1600, 1300, 1000,
700,  600, 400)
Bo <- c(10.057, 2.417, 2.192, 1.916, 1.736, 1.617, 1.504, 1.416, 1.326, 1.268,
1.205, 1.149, 1.131, 1.093)

Rv <- c(84.11765, 84.11765, 70.5, 56.2, 46.5, 39.5, 33.8, 29.9, 27.3, 25.5, 25.9,
28.3, 29.8, 33.5) / 1e6

Rs <- c(11566, 2378, 2010, 1569, 1272, 1067, 873, 719, 565, 461, 349, 249, 218,
141)

Bg <- c(0.87, 0.88, 0.92, 0.99, 1.08, 1.20, 1.35, 1.56, 1.85, 2.28, 2.95, 4.09,
4.68, 6.53) / 1000

cw <- 3e-6

Bwi <- 10.05

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

muo <- c(0.0612, 0.062, 0.1338, 0.1826, 0.2354, 0.3001, 0.3764, 0.4781, 0.6041,
0.7746, 1.0295, 1.358, 1.855, 2.500)

mug <- c(0.0612, 0.062, 0.0554, 0.0436, 0.0368, 0.0308, 0.0261, 0.0222, 0.0191,
0.0166, 0.0148, 0.0135, 0.0125, 0.0115)

muw <- rep(0.25, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg, Bw = Bw,
 muo = muo, mug = mug, muw = muw)

p <- c(3700, 3650, 3400, 3100, 2800, 2500, 2200, 1900, 1600, 1300, 1000, 700,
600)

We <- rep(0, length.out = length(p))

Np <- c(0, 28.6, 93, 231, 270, 379, 481, 517.2, 549, 580, 675, 755, 803) *1e3

Gp <- c(0, 0.34, 1.2, 3.3, 4.3, 6.6, 9.1, 10.5, 12, 12.8, 16.4, 19.1, 20.5) * 1e9

Wp <- rep(0, length.out = length(p))

Wi <- rep(0, length.out = length(p))

wf <- rep(1, length.out = length(p))

mbal_param_gas_lst <- mbal_perform_param_gas(input_unit = "Field",
output_unit = "Field", G = 2.41e10, aquifer_model = NULL,
phi = 0.1, swi = 0.2, Np = Np, Gp = Gp, Wp = Wp, Wi = Wi, We = We, pd = 3650,
p = p, pvt = pvt_table, M = 0, cf = 2e-6, wf = wf, sgrw = 0.15)

dplyr::glimpse(mbal_param_gas_lst)
}
