% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_oil_optim.R
\name{mbal_optim_param_oil}
\alias{mbal_optim_param_oil}
\title{A list object of class 'optimization_oil' for material balance analysis}
\usage{
mbal_optim_param_oil(
  input_unit = "Field",
  output_unit = "Field",
  unknown_param = NULL,
  aquifer_model = NULL,
  N = NULL,
  m = NULL,
  phi = NULL,
  swi = NULL,
  Np = NULL,
  Rp = NULL,
  Wp = NULL,
  Gi = NULL,
  Wi = NULL,
  We = NULL,
  pb = NULL,
  p = NULL,
  pvt = NULL,
  cf = NULL,
  phi_a = NULL,
  perm_h_a = NULL,
  perm_v_a = NULL,
  h_a = NULL,
  r_a = NULL,
  r_R = NULL,
  w_a = NULL,
  l_a = NULL,
  tetha = NULL,
  muw_a = NULL,
  cw_a = NULL,
  cf_a = NULL,
  wf = NULL,
  sorg = NULL,
  sorw = NULL,
  mult_len = NULL,
  lower = NULL,
  upper = NULL,
  control = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, only the character string 'Field' is accepted}

\item{output_unit}{a unit system for properties, only the character string 'Field' is accepted}

\item{unknown_param}{a character string showing the unknown parameter(s). One of the following options: 'N', 'm', 'We', or 'N_m'}

\item{aquifer_model}{defaulted to \code{NULL}, otherwise must be a character string, one of the following eight options: 'uss_rad_edge', 'uss_rad_bottom', 'uss_lin_edge', 'uss_lin_bottom', 'pss_rad_edge', 'pss_lin_edge', 'pss_lin_bottom', 'pot'. For further information about each model, please see 'Raquifer' package reference manual (https://cran.r-project.org/web/packages/Raquifer/index.html)}

\item{N}{original oil in place, STB. If unknown, a \code{NULL} value must be assigned}

\item{m}{ratio of original gas cap volume to original oil leg volume, a numeric. If unknown, a \code{NULL} value must be assigned}

\item{phi}{reservoir porosity, a numeric fraction}

\item{swi}{initial water saturation in the reservoir, a numeric fraction}

\item{Np}{cumulative oil production, STB}

\item{Rp}{ratio of cumulative produced gas to cumulative produced oil}

\item{Wp}{cumulative water production, STB}

\item{Gi}{cumulative gas injection, SCF}

\item{Wi}{cumulative water injection, STB}

\item{We}{cumulative aquifer water influx, BBL. If unknown, a \code{NULL} value must be assigned}

\item{pb}{bubble point pressure, a numeric value, psi}

\item{p}{reservoir pressure, a numeric vector, psi}

\item{pvt}{a data frame of PVT properties including pressure 'p' in 'psi', oil formation volume factor 'Bo' in 'bbl/stb', solution gas-oil ratio 'Rs' in 'scf/stb', oil viscosity 'muo' in 'cp', volatilized oil-gas ratio 'Rv' in 'stb/scf', gas formation volume factor 'Bg' in 'bbl/scf', gas viscosity 'mug' in 'cp', water formation volume factor 'Bw' in 'bbl/stb', and water viscosity 'muw' in 'cp'}

\item{cf}{formation compressibility, a numeric value or vector, 1/psi}

\item{phi_a}{aquifer porosity, a numeric fraction}

\item{perm_h_a}{aquifer horizontal permeability, md. Used in 'uss_rad_edge', 'uss_rad_bottom', 'uss_lin_edge', 'pss_rad_edge', 'pss_lin_edge' and 'pot' aquifer models}

\item{perm_v_a}{vertical permeability, md. Used in 'uss_rad_bottom', 'uss_lin_bottom', 'pss_rad_bottom', and 'pss_lin_bottom' aquifer models}

\item{h_a}{aquifer height, ft}

\item{r_a}{aquifer radius, ft. Used in 'uss_rad_edge', 'uss_rad_bottom', 'pss_rad_edge', and 'pot' aquifer models}

\item{r_R}{reservoir radius, ft. Used in 'uss_rad_edge', 'uss_rad_bottom', 'pss_rad_edge', and 'pot' aquifer models}

\item{w_a}{aquifer width, ft. Used in 'uss_lin_edge', 'uss_lin_bottom', 'pss_lin_edge', and 'pss_lin_bottom' aquifer models}

\item{l_a}{aquifer length, ft. Used in 'uss_lin_edge', 'uss_lin_bottom', 'pss_lin_edge', and 'pss_lin_bottom' aquifer models}

\item{tetha}{fraction of reservoir encircled by the aquifer, degrees. Used in 'uss_rad_edge', 'pss_rad_edge', and 'pot' aquifer models}

\item{muw_a}{aquifer water viscosity, cp}

\item{cw_a}{aquifer water compressibility, a numeric value, 1/psi}

\item{cf_a}{aquifer formation compressibility, a numeric value, 1/psi}

\item{wf}{weight factor, a numeric vector of zeros and ones. A zero value excludes the entire row of reservoir history data at a particular time from the material balance analysis}

\item{sorg}{residual oil saturation in gas invaded zone (gas cap expansion or gas injection), a numeric fraction}

\item{sorw}{residual oil saturation in water invaded zone (aquifer encroachment or water injection), a numeric fraction}

\item{mult_len}{a numeric vector of initial estimates for the 'aquifer_model' parameters
A vector of length one for the 'pot' aquifer model. It applies as a multiplier to the radius of the aquifer
A vector of length two for the 'uss_rad_edge', and 'pss_rad_edge' aquifer models. The first parameter is applied as a multiplier to the aquifer radius, and the second parameter is applied as a multiplier to the aquifer horizontal permeability
A vector of length two for the 'uss_lin_edge', and 'pss_lin_edge' aquifer models. The first parameter is applied as a multiplier to the aquifer length, and the second parameter is applied as a multiplier to the aquifer horizontal permeability
A vector of length two for the 'uss_lin_bottom', and 'pss_lin_bottom' aquifer models. The first parameter is applied as a multiplier to the aquifer height, and the second parameter is applied as a multiplier to the aquifer vertical permeability
A vector of length three for the 'uss_rad_bottom' aquifer model. The first parameter is applied as a multiplier to the aquifer radius, the second parameter is applied as a multiplier to the aquifer horizontal permeability, and the third parameter is applied as a multiplier to the aquifer vertical permeability}

\item{lower}{an optional numeric vector of lower bounds for the 'aquifer_model' parameters. See 'minpack.lm' package for details}

\item{upper}{an optional numeric vector of upper bounds for the 'aquifer_model' parameters. See 'minpack.lm' package for details}

\item{control}{an optional list of control settings. See 'minpack.lm' package for details}
}
\value{
a list of class 'mbal_oil' with all the required parameters for the mbal_perform_oil() S3 methods
}
\description{
Create an object of class 'optimization_oil'
}
\examples{
p_pvt <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

Bo <- c(1.2511, 1.2353, 1.2222, 1.2122, 1.2022, 1.1922, 1.1822)

Rs <- c(510, 477, 450, 425, 401, 375, 352)

Bg <- c(0.00087, 0.00092, 0.00096, 0.00101, 0.00107, 0.00113, 0.00120)

cw <- 2e-6

Bwi <- 1.0

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

Rv <- rep(0, length(p_pvt))

muo <- rep(0.5, length(p_pvt))

muw <- rep(0.25, length(p_pvt))

mug <- rep(0.02, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg,
                       Bw = Bw, muo = muo, mug = mug, muw = muw)

p <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

We <- rep(0, length.out = length(p))

Np <- c(0, 3.295, 5.903, 8.852, 11.503, 14.513, 17.730) * 1e6

Rp <- c(0, 1050, 1060, 1160, 1235, 1265, 1300)

Wp <- rep(0, length.out = length(p))

Wi <- rep(0, length.out = length(p))

Gi <- rep(0, length.out = length(p))

wf <- c(1, 1, 1, 0, 1, 0, 1)

mbal_optim_oil_lst <- mbal_optim_param_oil(input_unit = "Field",
output_unit = "Field", unknown_param = "N_m", aquifer_model = NULL,
phi = 0.2, swi = 0.2, Np = Np,Rp = Rp, Wp = Wp, Gi = Gi, Wi = Wi,
We = We, pb = 3330, p = p, pvt = pvt_table, cf = 0, wf = wf,
sorg = 0.2, sorw = 0)

dplyr::glimpse(mbal_optim_oil_lst)
}
