% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_oil_forecast.R
\name{mbal_forecast_oil}
\alias{mbal_forecast_oil}
\title{Generic function for performance forecasting of an oil reservoir}
\usage{
mbal_forecast_oil(forecast_lst, time_lst)
}
\arguments{
\item{forecast_lst}{a list object of class 'forecast_oil'}

\item{time_lst}{a list object of class 'time/date'}
}
\value{
a data frame with estimates for saturation of fluids, liquid dropout, gas-oil ratio, recovery factor, and drive indices over a range of given pressures
}
\description{
Generate a data frame of reservoir production estimates, and fluids saturations and liquid dropout in the oil leg according to the class of 'forecast_lst' and 'time_lst' objects
}
\examples{
p_pvt <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

Bo <- c(1.2511, 1.2353, 1.2222, 1.2122, 1.2022, 1.1922, 1.1822)

Rs <- c(510, 477, 450, 425, 401, 375, 352)

Bg <- c(0.00087, 0.00092, 0.00096, 0.00101, 0.00107, 0.00113, 0.00120)

cw <- 2e-6

Bwi <- 1.0

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

Rv <- rep(0, length(p_pvt))

muo <- rep(0.5, length(p_pvt))

muw <- rep(0.25, length(p_pvt))

mug <- rep(0.02, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg,
                       Bw = Bw, muo = muo, mug = mug, muw = muw)

rel_perm <- as.data.frame(Rrelperm::kr2p_gl(SWCON = 0.2, SOIRG = 0.10,
SORG = 0.10, SGCON = 0.05, SGCRIT = 0.05, KRGCL = 0.3, KROGCG = 1,
NG = 0.93, NOG = 10, NP = 101))

colnames(rel_perm) <- c("Sg", "Sl", "Krg", "Krog")

p <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

Gi <- rep(0, length.out = length(p))

wf <- c(1, 1, 1, 0, 1, 0, 1)

forecast_lst <- mbal_forecast_param_oil(input_unit = "Field",
output_unit = "Field", N = 1.37e8, m = 0.377, phi = 0.2, swi = 0.2, Gi = Gi,
pb = 3330, p = p, pvt = pvt_table, cf = 0, wf = wf, sorg = 0.2,
rel_perm = rel_perm)

time_lst <- mbal_time(c(0, 365, 730, 1095, 1460, 1825, 2190), "day")

mbal_forecast_results <- mbal_forecast_oil(forecast_lst, time_lst)

dplyr::glimpse(mbal_forecast_results)
}
\references{
\insertRef{Walsh2003}{Rmbal}

\insertRef{Walsh1994a}{Rmbal}

\insertRef{Walsh1994}{Rmbal}

\insertRef{Walsh1995}{Rmbal}
}
