/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util.oxm;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.MessageTransformerSupport;

public abstract class AbstractXMLMessageTransformer
extends MessageTransformerSupport {
    protected MessageTransform transformType;

    public AbstractXMLMessageTransformer() {
        this(MessageTransform.XML);
    }

    public AbstractXMLMessageTransformer(MessageTransform transformType) {
        this.transformType = transformType;
    }

    public Message consumerTransform(Session session, MessageConsumer consumer, Message message) throws JMSException {
        switch (this.transformType) {
            case XML: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : message;
            }
            case OBJECT: {
                return message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message;
            }
            case ADAPTIVE: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : (message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message);
            }
        }
        return message;
    }

    public Message producerTransform(Session session, MessageProducer producer, Message message) throws JMSException {
        switch (this.transformType) {
            case XML: {
                return message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message;
            }
            case OBJECT: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : message;
            }
            case ADAPTIVE: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : (message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message);
            }
        }
        return message;
    }

    public MessageTransform getTransformType() {
        return this.transformType;
    }

    public void setTransformType(MessageTransform transformType) {
        this.transformType = transformType;
    }

    protected ObjectMessage textToObject(Session session, TextMessage textMessage) throws JMSException {
        Object object = this.unmarshall(session, textMessage);
        if (object instanceof Serializable) {
            ObjectMessage answer = session.createObjectMessage((Serializable)object);
            this.copyProperties(textMessage, answer);
            return answer;
        }
        throw new JMSException("Object is not serializable: " + object);
    }

    protected TextMessage objectToText(Session session, ObjectMessage objectMessage) throws JMSException {
        TextMessage answer = session.createTextMessage(this.marshall(session, objectMessage));
        this.copyProperties(objectMessage, answer);
        return answer;
    }

    protected abstract String marshall(Session var1, ObjectMessage var2) throws JMSException;

    protected abstract Object unmarshall(Session var1, TextMessage var2) throws JMSException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageTransform {
        XML,
        OBJECT,
        ADAPTIVE;

    }
}

