/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.transport.http.HttpTransportSupport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class HttpTransport
extends HttpTransportSupport {
    private static final Log LOG = LogFactory.getLog(HttpTransport.class);
    private HttpURLConnection sendConnection;
    private HttpURLConnection receiveConnection;
    private URL url;
    private String clientID;
    private volatile int receiveCounter;

    public HttpTransport(TextWireFormat wireFormat, URI remoteUrl) throws MalformedURLException {
        super(wireFormat, remoteUrl);
        this.url = new URL(remoteUrl.toString());
    }

    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        try {
            if (command.getDataStructureType() == 3) {
                boolean startGetThread = this.clientID == null;
                this.clientID = ((ConnectionInfo)command).getClientId();
                if (startGetThread && this.isStarted()) {
                    try {
                        super.doStart();
                    }
                    catch (Exception e) {
                        throw IOExceptionSupport.create(e);
                    }
                }
            }
            HttpURLConnection connection = this.getSendConnection();
            String text = this.getTextWireFormat().marshalText(command);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(text);
            ((Writer)writer).flush();
            int answer = connection.getResponseCode();
            if (answer != 200) {
                throw new IOException("Failed to post command: " + command + " as response was: " + answer);
            }
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Could not post command: " + command + " due to: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.trace("HTTP GET consumer thread starting for transport: " + this);
        URI remoteUrl = this.getRemoteUrl();
        while (!this.isStopped()) {
            try {
                HttpURLConnection connection = this.getReceiveConnection();
                int answer = connection.getResponseCode();
                if (answer != 200) {
                    if (answer == 408) {
                        LOG.trace("GET timed out");
                        continue;
                    }
                    LOG.warn("Failed to perform GET on: " + remoteUrl + " as response was: " + answer);
                    continue;
                }
                ++this.receiveCounter;
                InputStream is = connection.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(connection.getContentLength() > 0 ? connection.getContentLength() : 1024);
                int c = 0;
                while ((c = is.read()) >= 0) {
                    baos.write(c);
                }
                ByteSequence sequence = baos.toByteSequence();
                String data = new String(sequence.data, sequence.offset, sequence.length, "UTF-8");
                Command command = (Command)this.getTextWireFormat().unmarshalText(data);
                if (command == null) {
                    LOG.warn("Received null packet from url: " + remoteUrl);
                    continue;
                }
                this.doConsume(command);
            }
            catch (Throwable e) {
                if (!this.isStopped()) {
                    LOG.error("Failed to perform GET on: " + remoteUrl + " due to: " + e, e);
                    continue;
                }
                LOG.trace("Caught error after closed: " + e, e);
            }
            finally {
                this.safeClose(this.receiveConnection);
                this.receiveConnection = null;
            }
        }
    }

    protected HttpURLConnection createSendConnection() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.getRemoteURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        this.configureConnection(conn);
        conn.connect();
        return conn;
    }

    protected HttpURLConnection createReceiveConnection() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.getRemoteURL().openConnection();
        conn.setDoOutput(false);
        conn.setDoInput(true);
        conn.setRequestMethod("GET");
        this.configureConnection(conn);
        conn.connect();
        return conn;
    }

    protected void configureConnection(HttpURLConnection connection) {
        if (this.clientID != null) {
            connection.setRequestProperty("clientID", this.clientID);
        }
    }

    protected URL getRemoteURL() {
        return this.url;
    }

    protected HttpURLConnection getSendConnection() throws IOException {
        this.setSendConnection(this.createSendConnection());
        return this.sendConnection;
    }

    protected HttpURLConnection getReceiveConnection() throws IOException {
        this.setReceiveConnection(this.createReceiveConnection());
        return this.receiveConnection;
    }

    protected void setSendConnection(HttpURLConnection conn) {
        this.safeClose(this.sendConnection);
        this.sendConnection = conn;
    }

    protected void setReceiveConnection(HttpURLConnection conn) {
        this.safeClose(this.receiveConnection);
        this.receiveConnection = conn;
    }

    protected void doStart() throws Exception {
        if (this.clientID != null) {
            super.doStart();
        }
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        stopper.run(new Callback(){

            public void execute() throws Exception {
                HttpTransport.this.safeClose(HttpTransport.this.sendConnection);
            }
        });
        this.sendConnection = null;
        stopper.run(new Callback(){

            public void execute() {
                HttpTransport.this.safeClose(HttpTransport.this.receiveConnection);
            }
        });
    }

    private void safeClose(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }
}

