/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.virtual.SelectorAwareVirtualTopicInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualTopicInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationFilter;

public class VirtualTopic
implements VirtualDestination {
    private String prefix = "Consumer.*.";
    private String postfix = "";
    private String name = ">";
    private boolean selectorAware = false;

    public ActiveMQDestination getVirtualDestination() {
        return new ActiveMQTopic(this.getName());
    }

    public Destination intercept(Destination destination) {
        return this.selectorAware ? new SelectorAwareVirtualTopicInterceptor(destination, this.getPrefix(), this.getPostfix()) : new VirtualTopicInterceptor(destination, this.getPrefix(), this.getPostfix());
    }

    public void create(Broker broker, ConnectionContext context, ActiveMQDestination destination) throws Exception {
        DestinationFilter filter;
        if (destination.isQueue() && destination.isPattern() && broker.getDestinations(destination).isEmpty() && (filter = DestinationFilter.parseFilter(new ActiveMQQueue(this.prefix + ">"))).matches(destination)) {
            broker.addDestination(context, destination, false);
        }
    }

    public void remove(Destination destination) {
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSelectorAware(boolean selectorAware) {
        this.selectorAware = selectorAware;
    }

    public boolean isSelectorAware() {
        return this.selectorAware;
    }
}

