% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstat.pdist2.R
\name{rstat.pdist2}
\alias{rstat.pdist2}
\title{Pairwise Distance for Two Sets of Data on Manifolds}
\usage{
rstat.pdist2(input1, input2, type = c("intrinsic", "extrinsic"))
}
\arguments{
\item{input1}{a S3 object of \code{riemdata} class of \eqn{N} objects.}

\item{input2}{a S3 object of \code{riemdata} class of \eqn{M} objects. See \code{\link[RiemBase]{riemfactory}} for more details.}

\item{type}{type of distance, either \code{"intrinsic"} or \code{"extrinsic"}.}
}
\value{
an \eqn{(N\times M)} matrix of pairwise distances.
}
\description{
For two points \eqn{x,y \in \mathcal{M}}, two modes of distances are available; \emph{intrinsic} for geodesic distance 
on the manifold and \emph{extrinsic} for standard norm after equivariant embedding into Euclidean space. This function 
differs from \code{\link{rstat.pdist}} in that it now computes distances between two sets of data.
}
\examples{
### Generate 100 data points on Sphere S^2.
#   50 points from near (0,0,1), and
#   50 points from near (0,0,-1)

ndata = 50
theta = seq(from=-0.99,to=0.99,length.out=ndata)*pi
tmpx  = cos(theta)
tmpy  = sin(theta)

### Wrap those as 'riemdata' class
data1 = list()
data2 = list()
for (i in 1:ndata){
  tgt1 = c(tmpx[i],tmpy[i],1)  + stats::rnorm(3,sd=0.1)
  tgt2 = c(tmpx[i],tmpy[i],-1) + stats::rnorm(3,sd=0.1)
  
  data1[[i]] = tgt1/sqrt(sum(tgt1^2)) # projection near (0,0,1)
  data2[[i]] = tgt2/sqrt(sum(tgt2^2)) #                 (0,0,-1)  
}
spdata1 = RiemBase::riemfactory(data1, name="sphere")
spdata2 = RiemBase::riemfactory(data2, name="sphere")

### Compute Two Types of Distances and Visualize
dist.int = rstat.pdist2(spdata1, spdata2, type="intrinsic")
dist.ext = rstat.pdist2(spdata1, spdata2, type="extrinsic")

### Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
image(dist.int, main="intrinsic")
image(dist.ext, main="extrinsic")
par(opar)

}
\seealso{
\code{\link{rstat.pdist}}
}
