% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_test_disc_adj.R
\name{gof_test_disc_adj}
\alias{gof_test_disc_adj}
\title{This function performs a number of gof tests for discrete data and finds the adjusted p value}
\usage{
gof_test_disc_adj(
  x,
  pnull,
  rnull,
  vals,
  phat = function(x) -99,
  TS,
  TSextra = NA,
  nbins = c(50, 10),
  rate = 0,
  B = 5000,
  minexpcount = 5,
  ChiUsePhat = TRUE,
  doMethods = c("Wassp1", "W", "AD", "s-P")
)
}
\arguments{
\item{x}{data set (the counts)}

\item{pnull}{cumulative distribution function under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{vals}{a vector of values of discrete random variables}

\item{phat}{=function(x) -99, function to estimate parameters from the data, or -99 if no parameters aare estimated}

\item{TS}{=NA, user supplied function to find test statistics}

\item{TSextra}{=NA, list passed to TS, if desired}

\item{nbins}{=c(50, 10) number of bins for chi-square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{B}{=c(5000, 1000)  number of simulation runs for p values and for adjusted p value}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{= TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}

\item{doMethods}{Methods to include in tests}
}
\value{
A numeric matrix of test statistics and p.values
}
\description{
This function performs a number of gof tests for discrete data and finds the adjusted p value
}
