# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Find test statistics for continuous data
#' 
#' @param x A numeric vector.
#' @param Fx numeric vector of cdf probabilities.
#' @param param parameters for pnull
#' @param qnull An R function, the quantile function under the null hypothesis.
#' @param doMethod A character vector of methods to include
#' @keywords internal
#' @return A numeric vector with test statistics
TS_cont <- function(x, Fx, param, qnull, doMethod = as.character( c("KS", "K", "AD", "CvM", "W", "ZA", "ZK", "ZC", "Wassp1"))) {
    .Call(`_Rgof_TS_cont`, x, Fx, param, qnull, doMethod)
}

#' Find test statistics for discrete data
#' 
#' @param x An integer vector.
#' @param p A numeric vector of probabilities.
#' @param nm A matrix of pre-calculated (with nm_calc.cpp) numbers needed for Zhangs tests.
#' @param vals A numeric vector with the values of the discrete rv.
#' @param doMethod A character vector of methods to include
#' @keywords internal
#' @return A vector with test statistics
TS_disc <- function(x, p, nm, vals, doMethod = as.character( c("KS", "K", "AD", "CvM", "W", "ZA", "ZK", "ZC", "Wassp1"))) {
    .Call(`_Rgof_TS_disc`, x, p, nm, vals, doMethod)
}

#' count occurances in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @keywords internal
#' @return Integer vector of counts
bincounter_cpp <- function(x, bins) {
    .Call(`_Rgof_bincounter_cpp`, x, bins)
}

#' routine to bin continuous data and assure expected counts>5 
#' 
#' @param  x A numeric vector of numbers.
#' @param  pnull function to find CDF
#' @param  param parameter of pnull
#' @param  k =10, number of bins
#' @param  which =1, 1=equal probability bins, 2-equal size bins
#' @param Range =(-99999,99999) limits of possible observations, if any
#' @keywords internal
#' @return A vectors of bin edges
binner_cont <- function(x, pnull, param, k = 10L, which = 1L, Range = as.numeric( c(-99999,99999))) {
    .Call(`_Rgof_binner_cont`, x, pnull, param, k, which, Range)
}

#' routine to bin discrete data and assure expected counts>5 
#' 
#' @param  x An integer vector of counts.
#' @param  p cumulative distribution function values at vals
#' @param  k number of desired bins
#' @keywords internal
#' @return An integer vector of indices
binner_disc <- function(x, p, k = 10L) {
    .Call(`_Rgof_binner_disc`, x, p, k)
}

#' chi square statistic for continuous data
#' 
#' @param  param  Vector of parameters of pnull
#' @param  x  Vector of observations
#' @param  pnull Function to calculate probabilities (pmf)
#' @param  bins bins to use
#' @param  formula type of chi square formula to use
#' @param  rate rate of Poisson if sample size is random, 0 otherwise
#' @keywords internal
#' @return chi square statistic
chi_stat_cont <- function(param, x, pnull, bins, formula, rate = 0.0) {
    .Call(`_Rgof_chi_stat_cont`, param, x, pnull, bins, formula, rate)
}

#' chi square statistic for discrete data
#' 
#' @param  param parameter for pnull 
#' @param  x  Vector of observations
#' @param  pnull cumulative distribution function under the null hypothesis
#' @param  bins vector of indices of bins
#' @param  formula type of chi square formula to use
#' @param  rate rate of Poisson if sample size is random, 0 otherwise
#' @keywords internal
#' @return chi square statistic
chi_stat_disc <- function(param, x, pnull, bins, formula, rate = 0.0) {
    .Call(`_Rgof_chi_stat_disc`, param, x, pnull, bins, formula, rate)
}

#'
#' This function performs a number of chisquare gof tests for continuous data
#' @param  x data set
#' @param  pnull  cdf under the null hypothesis
#' @param  param  starting values of multi-D minimum chi square minimization
#' @param  nbins =c(100, 10) number of bins for chisquare tests
#' @param  formula Formula of chi square to use
#' @param  rate rate of Poisson if sample size is random
#' @param  Range  =(-99999, 99999) limits of possible observations, if any
#' @param  Minimize Should minimum chi square be found?
#' @keywords internal
#' @return A numeric matrix of test statistics, degrees of freedom and p values
chi_test_cont <- function(x, pnull, param, formula = "Pearson", rate = 0.0, nbins = as.integer( c(100, 10)), Range = as.numeric( c(-99999, 99999)), Minimize = 0L) {
    .Call(`_Rgof_chi_test_cont`, x, pnull, param, formula, rate, nbins, Range, Minimize)
}

#'
#' This function performs a number of chisquare gof tests for discrete data
#' @param  x data set
#' @param  pnull  cdf under the null hypothesis
#' @param  param  starting values of multi-D minimum chi square minimization
#' @param  nbins =c(100, 10) number of bins for chisquare tests
#' @param  formula type of chi square formula to use
#' @param  rate rate of Poisson if sample size is random, 0 otherwise
#' @param  Minimize Should minimum chi square be found?
#' @keywords internal
#' @return A numeric matrix of test statistics, degrees of freedom and p values
chi_test_disc <- function(x, pnull, param, nbins = as.integer( c(100, 10)), formula = "Pearson", rate = 0.0, Minimize = 0L) {
    .Call(`_Rgof_chi_test_disc`, x, pnull, param, nbins, formula, rate, Minimize)
}

#' run gof tests for continuous data
#' 
#' @param x A numeric vector of data
#' @param pnull R function (cdf)
#' @param phat  function to set or estimate parameters of pnull
#' @param rnull R function (generate data under null hypothesis)
#' @param qnull R function (quantiles under null hypothesis)
#' @param B (=5000) Number of simulation runs  
#' @param doMethod List methods to include
#' @keywords internal
#' @return A matrix of numbers
gof_cont <- function(x, pnull, phat, rnull, qnull, B = 5000L, doMethod = as.character( c("KS", "K", "AD", "CvM", "W", "ZA", "ZK", "ZC", "Wassp1"))) {
    .Call(`_Rgof_gof_cont`, x, pnull, phat, rnull, qnull, B, doMethod)
}

#' run gof tests for discrete data
#' 
#' @param x an integer vector of counts
#' @param pnull cumulative distribution function under the null hypothesis
#' @param vals numeric vector of values of discrete random variables.
#' @param rnull R function (generate data under null hypothesis)
#' @param phat function to estimate parameters
#' @param rate =0 rate of Poisson if sample size is random, 0 otherwise.
#' @param B (=5000) Number of simulation runs  
#' @param doMethod List methods to include
#' @keywords internal
#' @return A matrix of numbers
gof_disc <- function(x, pnull, vals, rnull, phat, rate = 0, B = 5000L, doMethod = as.character( c("KS", "K", "AD", "CvM", "W", "ZA", "ZK", "ZC", "Wassp1"))) {
    .Call(`_Rgof_gof_disc`, x, pnull, vals, rnull, phat, rate, B, doMethod)
}

#' calculate a matrix of numbers needed for Zhangs tests for discrete data
#' 
#' @param n An integer.
#' @keywords internal
#' @return A matrix of numbers
nm_calc <- function(n) {
    .Call(`_Rgof_nm_calc`, n)
}

#' find power of gof tests for continuous data
#' 
#' @param pnull R function (cdf)
#' @param phat  function to estimate parameters from the data
#' @param rnull R function (generate data under null hypothesis)
#' @param ralt  R function to generate data under alternative
#' @param param_alt parameters of ralt
#' @param qnull R function (quantiles under null hypothesis)
#' @param nbins =c(100,10) number of bins to use
#' @param rate rate of Poisson if sample size is random
#' @param Range =(-99999, 99999) limits of possible observations, if any
#' @param B  =c(1000, 1000) Number of simulation runs for power and null distribution
#' @param alpha =0.05, type I error of test 
#' @keywords internal
#' @return A matrix of powers
power_cont <- function(pnull, phat, rnull, ralt, param_alt, qnull, nbins = as.integer( c(100, 10)), rate = 0.0, Range = as.numeric( c(-99999, 99999)), B = as.integer( c(1000, 1000)), alpha = 0.05) {
    .Call(`_Rgof_power_cont`, pnull, phat, rnull, ralt, param_alt, qnull, nbins, rate, Range, B, alpha)
}

#' find power of gof tests for discrete data
#' 
#' @param pnull R function (cdf)
#' @param phat  function to estimate parameters from the data
#' @param rnull R function (generate data under null hypothesis)
#' @param ralt  R function to generate data under alternative
#' @param param_alt parameters of function ralt
#' @param vals vector of values of discrete random variable
#' @param nbins =c(100,10) number of bins to use 
#' @param rate rate of Poisson if sample size is random, 0 otherwise
#' @param B  =c(1000, 1000) Number of simulation runs for power and null distribution
#' @param alpha =0.05, type I error of test 
#' @keywords internal
#' @return A matrix of powers
power_disc <- function(pnull, phat, rnull, ralt, param_alt, vals, nbins = as.integer( c(100, 10)), rate = 0.0, B = as.integer( c(1000, 1000)), alpha = 0.05) {
    .Call(`_Rgof_power_disc`, pnull, phat, rnull, ralt, param_alt, vals, nbins, rate, B, alpha)
}

