% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_expression_levels}
\alias{search_expression_levels}
\title{Search for Expression Levels}
\usage{
search_expression_levels(client, rna_quantification_id = NULL,
  feature_ids = NULL, threshold = NULL, page_size = NULL,
  page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{rna_quantification_id}{The ID of the RNA Quantification to search within}

\item{feature_ids}{A list of Feature IDs. Only return expressions with any of the specified feature_ids.}

\item{threshold}{Number}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Expression Levels
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{

library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Find an rna quantification set to search in
rna_quantification_sets <- ref_client \%>\%
 search_rna_quantification_sets(d_id) \%>\% content()
rqs_id <- rna_quantification_sets$rnaQuantificationSets[[1]]$id

## Find an rna quantification to search in
rna_quantifications <- ref_client \%>\%
 search_rna_quantifications(rqs_id) \%>\% content()
rq_id <- rna_quantifications$rnaQuantifications[[1]]$id

## Search for expression levels in the rna quantification
expression_levels <- ref_client \%>\%
 search_expression_levels(rq_id) \%>\% content()
expression_levels

}

}

