% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_github_data.R
\name{load_github_data}
\alias{load_github_data}
\title{Load Data from GitHub Repositories}
\usage{
load_github_data(github_data_url)
}
\arguments{
\item{github_data_url}{The GitHub url of the dataset.}
}
\value{
A dataset specified by a GitHub url.
}
\description{
This function was found in
https://stackoverflow.com/questions/24846120/importing-data-into-r-rdata-from-github and can be
used to load .RData files from GitHub repositories. This function can be used to load the Callcenter,
Jambi, and Montana datasets from the Rfssa package hosted by GitHub at https://github.com/haghbinh/Rfssa.
It was found that hosting such datasets on GitHub and not including them in the Rfssa R package saved
a significant amount of space.
}
\examples{
\dontrun{
# Loading different datasets from the Rfssa repository hosted by GitHub.
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Callcenter.RData")
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Jambi.RData")
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Montana.RData")
}

}
