% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_abstraction_setup.R
\name{mod_abstraction_setup}
\alias{mod_abstraction_setup}
\alias{abstraction_setup_ui}
\alias{abstraction_instrument_ui}
\alias{abstraction_setup_server}
\title{Abstraction Module Selector}
\usage{
abstraction_setup_ui(id)

abstraction_instrument_ui(id)

abstraction_setup_server(id, subject_id)
}
\arguments{
\item{id}{The Module namespace}

\item{subject_id}{A reactive expression containing a subject identifier}
}
\value{
\emph{abstraction_setup_ui}:
\item{tagList}{A tagList containing a selectInput that allows for selection of
available abstraction setup modules and the setup UI for the selected abstraction
module.}
\emph{abstraction_instrument_ui}:
\item{tagList}{A tagList containing the selected abstraction module's data collection
instrument UI.}
\emph{abstraction_setup_server}:
\item{reactiveValues}{This module has no returns of its own, but will pass on
the \code{reactiveValues} returns from the user selected abstraction module.}
}
\description{
This module allows the user to select an available ReviewR abstraction module
from a dropdown list. It dynamically returns the abstraction setup and
instrument user interfaces as well as collected chart abstraction information
from the selected module.

This module consists of the following components:
\subsection{Module UI functions}{

\itemize{
\item{\code{abstraction_setup_ui}}: A tagList with a dropdown selector containing
available abstraction modules.
\item{\code{abstraction_instrument_ui}}: A uiOutput containing the data collection
instrument UI from the selected chart abstraction module.
}
}

\subsection{Module Server function}{

\itemize{
\item{\code{abstraction_setup_server}}: Processes user selection and dynamically returns
uiOutputs for the selected abstraction module's setup and data collection instrument
user interfaces. Any returns from the configured abstraction module are captured and
returned.
}
}
}
\keyword{internal}
