% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTTPError.R
\name{raise}
\alias{raise}
\title{Interrupts request processing}
\usage{
raise(x)
}
\arguments{
\item{x}{instance of \link{Response}. Can be created using \link{HTTPError}.
see examples.}
}
\value{
None - stops execution of the current expression and executes an error action.
}
\description{
Interrupts request processing and signals RestRserve to return HTTPError
}
\examples{
# catch exception
res = try(raise(HTTPError$bad_request()), silent = TRUE)
cond = attr(res, "condition")
# response is a valid Response instace
identical(cond$response$body$error, "400 Bad Request")

}
\seealso{
\link{HTTPError} \link{Application}
}
