/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.common.AbstractWriterRegistry;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.convert.out.common.WmlXsltExporterDelegate;
import org.docx4j.convert.out.html.AbstractHTMLExporter3;
import org.docx4j.convert.out.html.HTMLConversionContext;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLExporterXslt
extends AbstractHTMLExporter3 {
    private static final Logger log = LoggerFactory.getLogger(HTMLExporterXslt.class);
    protected static final String PROPERTY_HTML_OUTPUT_TYPE = "docx4j.Convert.Out.HTML.OutputMethodXML";
    protected static final String XHTML_TEMPLATE_RESOURCE = "org/docx4j/convert/out/html/docx2xhtml.xslt";
    protected static final String HTML_TEMPLATE_RESOURCE = "org/docx4j/convert/out/html/docx2html.xslt";
    protected static final String XSLT_RESOURCE_ROOT = "org/docx4j/convert/out/html/";
    protected static final URIResolver RESOURCES_URI_RESOLVER = new OutHtmlURIResolver();
    protected static HTMLExporterXslt instance = null;

    public HTMLExporterXslt() {
        super(new HTMLExporterXsltDelegate());
    }

    public HTMLExporterXslt(AbstractWriterRegistry writerRegistry) {
        super(new HTMLExporterXsltDelegate(), writerRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exporter<HTMLSettings> getInstance() {
        if (instance != null) return instance;
        Class<HTMLExporterXslt> clazz = HTMLExporterXslt.class;
        synchronized (HTMLExporterXslt.class) {
            if (instance != null) return instance;
            instance = new HTMLExporterXslt();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HTMLExporterXsltDelegate
    extends WmlXsltExporterDelegate<HTMLSettings, HTMLConversionContext> {
        public HTMLExporterXsltDelegate() {
            super(null);
        }

        @Override
        protected Templates loadDefaultTemplates() throws Docx4JException {
            StreamSource xsltSource = null;
            Templates ret = null;
            URIResolver originalURIResolver = null;
            try {
                originalURIResolver = XmlUtils.getTransformerFactory().getURIResolver();
                XmlUtils.getTransformerFactory().setURIResolver(RESOURCES_URI_RESOLVER);
                if (Docx4jProperties.getProperty(HTMLExporterXslt.PROPERTY_HTML_OUTPUT_TYPE, true)) {
                    log.info("Outputting well-formed XHTML..");
                    this.defaultTemplatesResource = HTMLExporterXslt.XHTML_TEMPLATE_RESOURCE;
                } else {
                    log.info("Outputting HTML tag soup..");
                    this.defaultTemplatesResource = HTMLExporterXslt.HTML_TEMPLATE_RESOURCE;
                }
                xsltSource = new StreamSource(ResourceUtils.getResource(this.defaultTemplatesResource));
                ret = XmlUtils.getTransformerTemplate(xsltSource);
            }
            catch (IOException e) {
                throw new Docx4JException("Exception loading template \"" + this.defaultTemplatesResource + "\", " + e.getMessage(), e);
            }
            catch (TransformerConfigurationException e) {
                throw new Docx4JException("Exception loading template \"" + this.defaultTemplatesResource + "\", " + e.getMessage(), e);
            }
            finally {
                XmlUtils.getTransformerFactory().setURIResolver(originalURIResolver);
            }
            return ret;
        }

        @Override
        protected Document getSourceDocument(HTMLSettings conversionSettings, HTMLConversionContext conversionContext) throws Docx4JException {
            WordprocessingMLPackage wmlPackage = conversionContext.getWmlPackage();
            return XmlUtils.marshaltoW3CDomDocument(wmlPackage.getMainDocumentPart().getJaxbElement());
        }

        @Override
        public void process(HTMLSettings conversionSettings, HTMLConversionContext conversionContext, OutputStream outputStream) throws Docx4JException {
            conversionContext.setCurrentPartMainDocument();
            super.process(conversionSettings, conversionContext, outputStream);
        }
    }

    protected static class OutHtmlURIResolver
    implements URIResolver {
        protected OutHtmlURIResolver() {
        }

        public Source resolve(String href, String base) throws TransformerException {
            try {
                return new StreamSource(ResourceUtils.getResource(HTMLExporterXslt.XSLT_RESOURCE_ROOT + href));
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
    }
}

