/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.img;

import java.io.File;
import java.util.LinkedHashMap;

import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Pic;

public class Image extends DocComponent implements HTML4R, PPTX4R{

	// for docx and pptx
	private byte[] image_bytes;
	private String filename;

	private float width_in;
	private float height_in;
	private long width_emu;
	private long height_emu;
	

	static private String PICTURE = 
			"<p:pic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"> "
		    + "<p:nvPicPr>"
		      + "<p:cNvPr id=\"${element_id}\" name=\"Picture ${element_id}\" />"
		      + "<p:cNvPicPr>"
		        + "<a:picLocks noChangeAspect=\"1\"/>"
		      + "</p:cNvPicPr>"
	            + "<p:nvPr>"
	            	+ "<p:ph idx=\"${idx}\"/>"//+ "<p:ph idx=\"${idx}\" ${size}/>"
	            + "</p:nvPr>"
		    + "</p:nvPicPr>"
		    + "<p:blipFill>"
		      + "<a:blip r:embed=\"${rEmbedId}\" cstate=\"print\"/>"
		      + "<a:stretch>"
		        + "<a:fillRect/>"
		      + "</a:stretch>"
		    + "</p:blipFill>"
		    + "<p:spPr>"
		      + "<a:xfrm>"
		        + "<a:off x=\"0\" y=\"0\"/>"
		        + "<a:ext cx=\"0\" cy=\"0\"/>"
		      + "</a:xfrm>"
		      + "<a:prstGeom prst=\"rect\">"
		        + "<a:avLst/>"
		      + "</a:prstGeom>"
		    + "</p:spPr>"
		  + "</p:pic>";

	public Image(String filename, int ppi) throws Exception {
		super();
		this.filename = filename;
		
		File file = new File(filename);
		image_bytes = org.lysis.reporters.img.Imageutils.convertImageToByteArray(file);
		if( !filename.toLowerCase().endsWith(".wmf") && !filename.toLowerCase().endsWith(".emf") ) {
			float[] dims = org.lysis.reporters.img.Imageutils.getImageInfo(file, ppi);
			setDim(dims[0], dims[1]);
		} 
	}
	
	public Image(String filename, float w, float h) throws Exception {
		super();
		
		this.filename = filename;
		
		File file = new File(filename);
		image_bytes = org.lysis.reporters.img.Imageutils.convertImageToByteArray(file);
		setDim(w, h);
	}
	
	public long nextUniqueId(){
		return unique_id+2;
	}
	
	public void setDim(double w, double h){
		width_in = (float)w;
		height_in = (float)h;
		width_emu = (long)(width_in * 914400);
		height_emu = (long)(height_in * 914400);
//		System.out.println("width_in:" + width_in + " - height_in: " + height_in );
//		System.out.println("width_emu:" + width_emu + " - height_emu: " + height_emu );
		this.setExt(width_emu, height_emu);
	}


	public Object get_pptx_elt() throws Exception {
				
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(pptx_mlp, slidePart, image_bytes);
        Relationship rel = slidePart.addTargetPart(imagePart);
        


		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("element_id", shape_id + "" );
        mappings.put("rEmbedId", rel.getId() );
        mappings.put("idx", unique_id + "" );

        Object o = org.docx4j.XmlUtils.unmarshallFromTemplate(PICTURE, mappings, Context.jcPML, Pic.class ) ;
        ((Pic)o).getSpPr().setXfrm(getXfrm());
        return o;
	}
	
	public R get_docx_run( ) throws Exception {
		BinaryPartAbstractImage imagePart =BinaryPartAbstractImage.createImagePart(docx_mlp, image_bytes);
		Inline inline = imagePart.createImageInline(filename, "image", (int)unique_id, (int)unique_id + 1, false);
		inline.getGraphic().getGraphicData().getPic().getSpPr().setXfrm(getXfrm());
		inline.setExtent(getXfrm().getExt());
		
		R run = new R(); 

		Drawing drawing = new Drawing(); 
		run.getContent().add(drawing); 
		drawing.getAnchorOrInline().add(inline); 
		return run; 		
	}
	
	public P get_docx_elt( ) throws Exception {
		
		BinaryPartAbstractImage imagePart =BinaryPartAbstractImage.createImagePart(docx_mlp, image_bytes);
		Inline inline = imagePart.createImageInline(filename, "image", (int)unique_id, (int)unique_id + 1, false);
		inline.getGraphic().getGraphicData().getPic().getSpPr().setXfrm(getXfrm());
		inline.setExtent(getXfrm().getExt());
		
		P paragraph = new P(); 
		paragraph.setPPr(getPPr());
		
		addBookmark(paragraph);

		R run = new R(); 
		paragraph.getContent().add(run); 

		Drawing drawing = new Drawing(); 
		run.getContent().add(drawing); 
		drawing.getAnchorOrInline().add(inline); 

		return paragraph; 		
	}
	
	@Override
	public String getHTML() {
		String out = "";
		LinkedHashMap<String, String> ppr = getParProperties().get_html_pp();
		String pStart = "<p style=\"" + Format.getJSString(ppr) + "\">";
		String pStop = "</p>";
		
		out += pStart + getRunHTML() + pStop;
		return out;
	}

	public String getRunHTML() {
		String out = "<img src=\"data:image/png;base64," 
			+ new String( org.apache.commons.codec.binary.Base64.encodeBase64(image_bytes) ) 
			+ "\" width=\"" + (int)(width_in*72) + "\" height=\"" + (int)(height_in*72) + "\">";
		return out;
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

}
