% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addImage.docx.R
\name{addImage.docx}
\alias{addImage.docx}
\title{Add external image into a docx object}
\usage{
\method{addImage}{docx}(doc, filename, bookmark,
  par.properties = parProperties(text.align = "center", padding = 5), width,
  height, ppi = 72, ...)
}
\arguments{
\item{doc}{Object of class \code{\link{docx}} where external image has to be added}

\item{filename}{\code{"character"} value, complete filename of the external image}

\item{bookmark}{a character value ; id of the Word bookmark to replace by the image.
optional. if missing, image is added at the end of the document. See \code{\link{bookmark}}.}

\item{par.properties}{paragraph formatting properties of the paragraph that contains images.
An object of class \code{\link{parProperties}}}

\item{width}{image width in inches}

\item{height}{image height in inches}

\item{ppi}{dot per inches, default to 72}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{docx}}.
}
\description{
Add external images into a \code{\link{docx}} object.
}
\details{
If arguments width and height are missing, values will be defined as
their respective number of pixels divide by \code{ppi}.
}
\examples{
\dontrun{
doc.filename = "addImage_example.docx"

# set default font size to 10
options( "ReporteRs-fontsize" = 10 )

doc = docx( )
# files 'logo.jpg' and 'logosm.jpg' only exist in R for Windows
img.file1 = file.path( Sys.getenv("R_HOME"), "doc", "html", "logo.jpg" )
img.file2 = file.path( Sys.getenv("R_HOME"), "doc", "html", "logosm.jpg" )

if( file.exists( img.file1 ) && file.exists( img.file2 ) ){
  doc = addTitle( doc, "Add images with defaut PPI (72)", level = 1)
  doc = addTitle( doc, "Image 1", level = 2)
  doc = addImage(doc, img.file1 )
  doc = addTitle( doc, "Image 2", level = 2)
  doc = addImage(doc, img.file2 )
  doc = addTitle( doc, "Add images with their respective PPI", level = 1)
  doc = addTitle( doc, "Image 1", level = 2)
  doc = addImage(doc, img.file1, ppi = 300 )
  doc = addTitle( doc, "Image 2", level = 2)
  doc = addImage(doc, img.file2, ppi = 96)
  doc = addTitle( doc, "Add images with width and height", level = 1)
  doc = addImage(doc, img.file1, width = 4, height = 2 )
}
if( exists("win.metafile") ){
	win.metafile(filename = "image.wmf", width = 5, height = 5 )
	barplot( 1:6, col = 2:7)
	dev.off()
	
	doc =addImage(doc, "image.wmf", width = 5, height = 5 )
}

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{docx}}, \code{\link{addPlot.docx}}
, \code{\link{addImage}}, \code{\link{bookmark}}
}

