package org.lysis.reporters.html4r.elements.menu;

import org.lysis.reporters.tools.HTML4R;

public class MenuLink implements HTML4R{

	private String link;
	private String label;
	private boolean active;

	public MenuLink(String lab, String lnk){
		link = lnk;
		label = lab;
		active = false;
	}
	public void setActive(){
		active = true;
	}

	@Override
	public String getHTML() {
		String out = "<li";
		if( active ) out += " class=\"active\"";
		out += "><a href=\"" + link + "\">" + label + "</a></li>";
		return out;
	}
	
	@Override
	public String getCSS() {
		return "";
	}
	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	
}
