package org.lysis.reporters.img;

import java.io.File;

import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Pic;

public class Image extends DocComponent implements HTML4R, PPTX4R{

	// for docx and pptx
	private byte[] image_bytes;
	private String filename;
	private int width_px;
	private int height_px;
	

	static private String PICTURE = 
			"<p:pic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"> "
		    + "<p:nvPicPr>"
		      + "<p:cNvPr id=\"${element_id}\" name=\"Picture ${element_id}\" />"
		      + "<p:cNvPicPr>"
		        + "<a:picLocks noChangeAspect=\"1\"/>"
		      + "</p:cNvPicPr>"
	            + "<p:nvPr>"
	            	+ "<p:ph idx=\"${idx}\"/>"//+ "<p:ph idx=\"${idx}\" ${size}/>"
	            + "</p:nvPr>"
		    + "</p:nvPicPr>"
		    + "<p:blipFill>"
		      + "<a:blip r:embed=\"${rEmbedId}\" cstate=\"print\"/>"
		      + "<a:stretch>"
		        + "<a:fillRect/>"
		      + "</a:stretch>"
		    + "</p:blipFill>"
		    + "<p:spPr>"
		      + "<a:xfrm>"
		        + "<a:off x=\"0\" y=\"0\"/>"
		        + "<a:ext cx=\"0\" cy=\"0\"/>"
		      + "</a:xfrm>"
		      + "<a:prstGeom prst=\"rect\">"
		        + "<a:avLst/>"
		      + "</a:prstGeom>"
		    + "</p:spPr>"
		  + "</p:pic>";

	public Image(String filename) throws Exception {
		super();
		
		this.filename = filename;
		
		File file = new File(filename);
		image_bytes = org.lysis.reporters.img.Imageutils.convertImageToByteArray(file);
		int[] dims = org.lysis.reporters.img.Imageutils.getDimensions(image_bytes);
	
		int physicalWidthDpi = dims[2];
		int physicalHeightDpi = dims[3];
		
		double width_emu = dims[0] * 72 * 12700 ;width_emu = width_emu  / physicalWidthDpi ;
		double height_emu = dims[1] * 72 * 12700;height_emu = height_emu / physicalHeightDpi;
		this.setExt((long)width_emu, (long)height_emu);
		
	}
	public long nextUniqueId(){
		return unique_id+2;
	}
	public void setDim(int w, int h){
		width_px = w;
		height_px = h;
	}


	public Object get_pptx_elt() throws Exception {
				
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(pptx_mlp, slidePart, image_bytes);
        Relationship rel = slidePart.addTargetPart(imagePart);
        


		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("element_id", shape_id + "" );
        mappings.put("rEmbedId", rel.getId() );
        mappings.put("idx", unique_id + "" );

        Object o = org.docx4j.XmlUtils.unmarshallFromTemplate(PICTURE, mappings, Context.jcPML, Pic.class ) ;

        return o;
	}
	

	public P get_docx_elt( ) throws Exception {
		
		BinaryPartAbstractImage imagePart =BinaryPartAbstractImage.createImagePart(docx_mlp, image_bytes);
		Inline inline = imagePart.createImageInline(filename, "Alternative text", (int)unique_id, (int)unique_id + 1, false);
		inline.getGraphic().getGraphicData().getPic().getSpPr().setXfrm(getXfrm());
		inline.setExtent(getXfrm().getExt());
		
		P paragraph = new P(); 
		paragraph.setPPr(getPPr());
		
		addBookmark(paragraph);

		R run = new R(); 
		paragraph.getContent().add(run); 

		Drawing drawing = new Drawing(); 
		run.getContent().add(drawing); 
		drawing.getAnchorOrInline().add(inline); 

		return paragraph; 		
	}
	
	@Override
	public String getHTML() {
		String out = "";
		out += "<img src=\"data:image/png;base64," 
			+ new String( org.apache.commons.codec.binary.Base64.encodeBase64(image_bytes) ) 
			+ "\" width=\"" + width_px + "\" height=\"" + height_px + "\">";
		return utils.div( out );
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}
}
