/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.img;

import java.io.File;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import org.apache.commons.codec.binary.Base64;
import org.docx4j.XmlUtils;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.img.Imageutils;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Pic;

public class Image
extends DocComponent
implements HTML4R,
PPTX4R {
    private byte[] image_bytes;
    private String filename;
    private int width_px;
    private int height_px;
    private static String PICTURE = "<p:pic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"> <p:nvPicPr><p:cNvPr id=\"${element_id}\" name=\"Picture ${element_id}\" /><p:cNvPicPr><a:picLocks noChangeAspect=\"1\"/></p:cNvPicPr><p:nvPr><p:ph idx=\"${idx}\"/></p:nvPr></p:nvPicPr><p:blipFill><a:blip r:embed=\"${rEmbedId}\" cstate=\"print\"/><a:stretch><a:fillRect/></a:stretch></p:blipFill><p:spPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"0\" cy=\"0\"/></a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom></p:spPr></p:pic>";

    public Image(String filename) throws Exception {
        this.filename = filename;
        File file = new File(filename);
        this.image_bytes = Imageutils.convertImageToByteArray(file);
        int[] dims = Imageutils.getDimensions(this.image_bytes);
        int physicalWidthDpi = dims[2];
        int physicalHeightDpi = dims[3];
        double width_emu = dims[0] * 72 * 12700;
        double height_emu = dims[1] * 72 * 12700;
        this.setExt((long)(width_emu /= (double)physicalWidthDpi), (long)(height_emu /= (double)physicalHeightDpi));
    }

    @Override
    public long nextUniqueId() {
        return this.unique_id + 2L;
    }

    public void setDim(int w, int h) {
        this.width_px = w;
        this.height_px = h;
    }

    @Override
    public Object get_pptx_elt() throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)this.pptx_mlp, (Part)this.slidePart, (byte[])this.image_bytes);
        Relationship rel = this.slidePart.addTargetPart((Part)imagePart);
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("element_id", String.valueOf(this.shape_id));
        mappings.put("rEmbedId", rel.getId());
        mappings.put("idx", String.valueOf(this.unique_id));
        Object o = XmlUtils.unmarshallFromTemplate((String)PICTURE, mappings, (JAXBContext)Context.jcPML, Pic.class);
        return o;
    }

    public P get_docx_elt() throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)this.docx_mlp, (byte[])this.image_bytes);
        Inline inline = imagePart.createImageInline(this.filename, "Alternative text", (int)this.unique_id, (int)this.unique_id + 1, false);
        inline.getGraphic().getGraphicData().getPic().getSpPr().setXfrm(this.getXfrm());
        inline.setExtent(this.getXfrm().getExt());
        P paragraph = new P();
        paragraph.setPPr(this.getPPr());
        this.addBookmark(paragraph);
        R run = new R();
        paragraph.getContent().add(run);
        Drawing drawing = new Drawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return paragraph;
    }

    @Override
    public String getHTML() {
        String out = "";
        out = String.valueOf(out) + "<img src=\"data:image/png;base64," + new String(Base64.encodeBase64((byte[])this.image_bytes)) + "\" width=\"" + this.width_px + "\" height=\"" + this.height_px + "\">";
        return utils.div(out);
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }
}

