/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.texts;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.pptx4r.elements.Utils;
import org.lysis.reporters.pptx4r.tools.Format;
import org.lysis.reporters.texts.TextProperties;

public class Paragraph
implements HTML4R {
    private LinkedHashMap<Integer, String> textList = new LinkedHashMap();
    private LinkedHashMap<Integer, TextProperties> formatList = new LinkedHashMap();
    private int index = 0;

    public void addText(String value, TextProperties tp) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, tp);
    }

    public void setTextProperties(TextProperties tp) {
        for (int key : this.formatList.keySet()) {
            this.formatList.put(key, tp);
        }
    }

    public void addText(String value) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, null);
    }

    public String toString() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                out = String.valueOf(out) + this.textList.get(i);
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    LinkedHashMap<String, String> rpr = org.lysis.reporters.html4r.tools.Format.getTextProperties(tp.getColor(), tp.getSize(), tp.isBold(), tp.isItalic(), tp.isUnderlined(), tp.getFontfamily(), tp.getValign());
                    out = String.valueOf(out) + utils.span_style(this.textList.get(i), org.lysis.reporters.html4r.tools.Format.getJSString(rpr));
                } else {
                    out = String.valueOf(out) + utils.span(this.textList.get(i));
                }
                ++i;
            }
        }
        return out;
    }

    public P getP() {
        P p = new P();
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    R run = new R();
                    Text text = new Text();
                    text.setValue(this.textList.get(i));
                    text.setSpace("preserve");
                    run.getContent().add(text);
                    RPr rpr = org.lysis.reporters.docx4r.tools.Format.getTextProperties(tp.getColor(), tp.getSize(), tp.isBold(), tp.isItalic(), tp.isUnderlined(), tp.getFontfamily(), tp.getValign());
                    run.setRPr(rpr);
                    p.getContent().add(run);
                } else {
                    R run = new R();
                    Text text = new Text();
                    text.setValue(this.textList.get(i));
                    text.setSpace("preserve");
                    run.getContent().add(text);
                    p.getContent().add(run);
                }
                ++i;
            }
        }
        return p;
    }

    public CTTextParagraph getCTTextParagraph() throws Exception {
        CTTextParagraph textPar = new CTTextParagraph();
        if (this.index > 0) {
            List runs = textPar.getEGTextRun();
            int i = 1;
            while (i <= this.index) {
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    CTTextCharacterProperties rpr = Format.getTextProperties(tp.getColor(), tp.getSize(), tp.isBold(), tp.isItalic(), tp.isUnderlined(), tp.getFontfamily(), tp.getValign());
                    CTRegularTextRun textRun = Utils.getRun(this.textList.get(i));
                    textRun.setRPr(rpr);
                    runs.add(textRun);
                } else {
                    CTRegularTextRun textRun = Utils.getRun(this.textList.get(i));
                    runs.add(textRun);
                }
                ++i;
            }
        }
        return textPar;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

