/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docx4r.elements;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import javax.xml.bind.JAXBElement;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.lysis.reporters.docx4r.tools.Format;

public class POT {
    private String style;
    private MainDocumentPart mdp;
    private LinkedHashMap<Integer, P> pList;
    private int index;
    private boolean hasBookmark;
    private JAXBElement<CTBookmark> bmStart;
    private JAXBElement<CTMarkupRange> bmEnd;

    public POT(WordprocessingMLPackage doc, String stylename) {
        this.style = stylename;
        this.mdp = doc.getMainDocumentPart();
        this.pList = new LinkedHashMap();
        this.index = -1;
        this.hasBookmark = false;
    }

    public void setBookmark(String bookmark, BigInteger bookmarkID) {
        this.hasBookmark = true;
        ObjectFactory factory = Context.getWmlObjectFactory();
        CTBookmark bm = new CTBookmark();
        bm.setId(bookmarkID);
        bm.setName(bookmark);
        this.bmStart = factory.createBodyBookmarkStart(bm);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(bookmarkID);
        this.bmEnd = factory.createBodyBookmarkEnd(mr);
    }

    public void addP() {
        ++this.index;
        P p = this.mdp.createStyledParagraphOfText(this.style, "");
        this.pList.put(this.index, p);
    }

    public void addPot(String value, int size, boolean bold, boolean italic, boolean underlined, String color, String fontfamily, String valign) {
        P p = this.pList.get(this.index);
        R run = new R();
        Text text = new Text();
        text.setValue(value);
        text.setSpace("preserve");
        run.getContent().add(text);
        RPr rpr = Format.getTextProperties(color, size, bold, italic, underlined, fontfamily, valign);
        run.setRPr(rpr);
        p.getContent().add(run);
    }

    public void addText(String value) {
        P p = this.pList.get(this.index);
        R run = new R();
        Text text = new Text();
        text.setValue(value);
        text.setSpace("preserve");
        run.getContent().add(text);
        p.getContent().add(run);
    }

    public int getLength() {
        return this.index + 1;
    }

    public P getP(int i) {
        P out = this.pList.get(i);
        if (this.hasBookmark && i == 0 && this.getLength() == 1) {
            out.getContent().add(0, this.bmStart);
            out.getContent().add(this.index + 1, this.bmEnd);
        } else if (this.hasBookmark && i == 0 && this.getLength() > 1) {
            out.getContent().add(0, this.bmStart);
        } else if (this.hasBookmark && i == this.index && this.getLength() > 1) {
            out.getContent().add(this.index + 1, this.bmEnd);
        }
        return out;
    }
}

