% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcTrep.R
\name{calcTrep}
\alias{calcTrep}
\title{A function to calculate Trep values from a sync-seq experiment
calcTrep function fits a Boltzman sigmoid function into relative copy number datapoints for every
genomic bin of the provided sync-seq merged dataframe. It then extracts time at which half of the
cells have this genomic bin replicated (Trep). The output of the function is a dataframe containing
Trep and TrepErr data for every genomic bin in a BED-like format.}
\usage{
calcTrep(ratioDFs, times)
}
\arguments{
\item{ratioDFs}{A merged ratios dataframe containing sync-seq samples (dataframe).}

\item{times}{Time series data in the same order as in the ratioDFs (numeric vector).}
}
\description{
A function to calculate Trep values from a sync-seq experiment
calcTrep function fits a Boltzman sigmoid function into relative copy number datapoints for every
genomic bin of the provided sync-seq merged dataframe. It then extracts time at which half of the
cells have this genomic bin replicated (Trep). The output of the function is a dataframe containing
Trep and TrepErr data for every genomic bin in a BED-like format.
}
\examples{
TrepDF <- calcTrep(subset(syncSeq[["data"]],chrom=="chrI"),times=c(25,30,35,40,45,50,90))
}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{replication}
\keyword{sigmoid}
\keyword{trep}
