% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_joint.test.R
\name{N_joint.test}
\alias{N_joint.test}
\title{Monte Carlo test on the number of upper and lower records}
\usage{
N_joint.test(XM_T, stand = FALSE, samples = 1000,
  trend = "increasing")
}
\arguments{
\item{XM_T}{A  matrix.}

\item{stand}{Logical flag. If \code{TRUE}  uses a standarized version of the test statistic.}

\item{samples}{An integer specifying the number of replicates used in the Monte Carlo approach.}

\item{trend}{A character string indicating the type of trend ("increasing" or "decreasing")  of the alternative hypothesis.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{Value of the likelihood ratio statistic.}
\item{p.value}{P-value.}
\item{samples}{Number of samples  used in the Monte Carlo approach.}
\item{method}{A character string indicating if the statistic is standardized or not.}
\item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs a Monte Carlo test  based on  the number of upper and lower  records, \eqn{N_t} and  \eqn{N_t^{low}},
to study the hypothesis of the classical record model.
}
\details{
The null  hypothesis  of this  test is that  the  expected value of the number of upper and lower records  in the observation period
is the same \eqn{E(N_T)=E(N_T^{low})}. Two statistics can be used,   \eqn{\bar N_t- \bar N_t^{low}},  or its standardized version;
\eqn{\bar N_t} and \eqn{\bar N_t^{low}} are the mean of the number of records up to time \eqn{t}, calculated from a samples of \eqn{M} vectors (columns in \code{XM_T}).

 These statistics are useful  when the alternative hypotehsis is that the  sequences of variables in the vectors have a monotonou trend. If the trend is increasing
  the statistic will take high values while if it is decreasing, it will take low values. The type of trend has to be specified at
  argument \code{trend} to calculate  the adequate p-value.

The distribution  of the statistic  under the hypothesis of the classical record model is obtained using a bootstrap approach.
}
\examples{
N_joint.test(ZaragozaSeries, stan=TRUE, samples=200)
}
\seealso{
\code{\link{N_joint.plot}}, \code{\link{N.plot}}, \code{\link{N_normal.test}}
}
