% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/named_MM.R
\name{read_named_MM}
\alias{read_named_MM}
\title{Read a named sparse matrix in MatrixMarket text format}
\usage{
read_named_MM(
  file,
  skip = 0,
  n_max = Inf,
  class = c("dgCMatrix", "tibble"),
  guess_max = 20
)
}
\arguments{
\item{file}{the file to read}

\item{skip}{the number of records to skip (default: 0)}

\item{n_max}{the maximum number of records to read (default: Inf)}

\item{class}{the class of object to return. By default a "dgCMatrix".
If "tibble" is chosen, the sparse matrix is returned as a tibble with
3 columns: i (row index), j (column index) and x (values) and
an "header" attribute containing the matrix rownames and colnames.}

\item{guess_max}{the number of lines to read to find the header.
(see \code{\link[=read_named_MM_header]{read_named_MM_header()}})}
}
\value{
By default a dgCMatrix.
If the "tibble" class is chosen, the sparse matrix is returned as
a tibble with 3 columns: i (row index), j (column index) and x (values) and
an "header" attribute containing the matrix rownames and colnames.
}
\description{
Read a named sparse matrix in MatrixMarket text format
}
