% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_confrontation_report.R
\name{format_confrontation_report}
\alias{format_confrontation_report}
\title{Format confrontation report for printing in console}
\usage{
format_confrontation_report(cr, title = "Model")
}
\arguments{
\item{cr}{the confrontation report from \link{confront_data}}

\item{title}{a character with a single value corresponding to the report
title (e.g. database/model name)}
}
\description{
Format confrontation report for printing in console
}
\examples{
## Read the model ----
hpo_from_sql <- read_SQL_data_model(
   system.file("examples/HPO-model.sql", package="ReDaMoR")
)
## Confront to data ----
confrontation_report <- confront_data(
   hpo_from_sql,
   path=list.files(
      system.file("examples/HPO-subset", package="ReDaMoR"),
      full.names=TRUE
   ),
   verbose=FALSE,
   returnData=TRUE
)
## Show the report in console ----
format_confrontation_report(confrontation_report) \%>\% cat()
## Format the report using markdown ----
format_confrontation_report_md(confrontation_report) \%>\% cat()
}
