% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{distances}
\alias{distances}
\title{distances - Observation distances}
\usage{
distances(ml, na.rm = TRUE, ...)
}
\arguments{
\item{ml}{Either a Rdistance 'model frame' or an Rdistance 
'fitted object'.  Both are of class "dfunc". 
Rdistance 'model frames' are lists containing components 
necessary to estimate a distance function, but no estimates. 
Rdistance 'model frames' are typically
produced by calls to \code{\link{parseModel}}. 
Rdistance 'fitted objects'
are typically produced by calls to \code{\link{dfuncEstim}}.
'Fitted objects' are 'model frames'
with additional components such as the parameters estimates, 
log likelihood value, convergence information, and the variance-
covariance matrix of the parameters.}

\item{na.rm}{Whether to include or exclude missing distance values. 
In \code{ml}, the model list containing the model frame, missing 
values of the response (distance) are potentially present for two 
reasons: (1) they are outside the strip w.lo to w.hi, and (2) they
are missing because the crew did not get a distance for that observation.}

\item{...}{Ignored}
}
\value{
A vector containing observation distances contained
in the Rdistance model frame.
}
\description{
Extract the observation distances (i.e., responses for 
an Rdistance model) from an Rdistance model frame.
}
\examples{

data(sparrowDf)
sparrowModel <- parseModel( sparrowDf, dist ~ observer )
stats::model.response(sparrowModel$mf)
distances(sparrowModel) # same, but future-proof

}
