% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perpDists.R
\name{perpDists}
\alias{perpDists}
\title{Compute off-transect distances from sighting distances and angles}
\usage{
perpDists(sightDist, sightAngle, data)
}
\arguments{
\item{sightDist}{Character, name of column in \code{data} that contains the observed or sighting distances from the observer to the detected objects.}

\item{sightAngle}{Character, name of column in \code{data} that contains the observed or sighting angles from the line transect to the detected 
objects.  Angles must be measured in degrees.}

\item{data}{data.frame object containing sighting distance and sighting angle.}
}
\value{
A vector of off-transect (or perpendicular) distances.  Units are the same as \code{sightDist}.
}
\description{
Computes off-transect (also called 'perpendicular') distances from measures of sighting distance and sighting angle.
}
\details{
If observers recorded sighting distance and sighting angle (as is often common in line transect surveys), use this function to convert 
  to off-transect distances, the required input data for \code{F.dfunc.estim}.
}
\examples{
# Load the example dataset of sparrow detections from package
data(sparrowDetectionData)
# Compute perpendicular, off-transect distances from the observer's sight distance and angle
sparrowDetectionData$perpDist <- perpDists(sightDist="sightdist", sightAngle="sightangle",
                                           data=sparrowDetectionData)
}
\references{
Buckland, S.T., Anderson, D.R., Burnham, K.P. and Laake, J.L. 1993. 
  \emph{Distance Sampling: Estimating Abundance of Biological Populations}. Chapman and Hall, London.
}
\seealso{
\code{\link{dfuncEstim}}
}
