% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppXsimd.R
\name{supportsAVX}
\alias{supportsAVX}
\title{Determine if CPU supports AVX SIMD instructions}
\usage{
supportsAVX()
}
\value{
Boolean
}
\description{
Determine if CPU supports AVX SIMD instructions
}
\examples{
\dontrun{

if (supportsAVX()) {
  Sys.setenv(PKG_CPPFLAGS = getAVXFlags())
  Rcpp::sourceCpp(verbose = TRUE, code='
    // [[Rcpp::plugins(cpp14)]]
    // [[Rcpp::depends(RcppXsimd)]]
               
    #include <Rcpp.h>
    #include "xsimd/xsimd.hpp"
               
    // [[Rcpp::export]] 
    void demoAVX() {
      xsimd::batch<double, 4> a(1.0);
      xsimd::batch<double, 4> b(1.0);
      Rcpp::Rcout << a << " + " << b << " = " << (a + b) << std::endl;
    }')
  demoAVX()
} else {
  message("AVX is not supported")
}
}

}
