% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movSumUE}
\alias{movSumUE}
\alias{movSumUEr}
\title{Weighted Simple Moving Sum for Unevenly Spaced Time Series}
\usage{
movSumUE(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE,
  sizeD = FALSE, align = "left")

movSumUEr(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE,
  sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{pos}{A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
N.B. We use integers to represent the (relative) positions of every point.}

\item{n}{An integer: moving window size, with 1 as default}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{w}{An optional weight vector of length \emph{n}. It will be automatically normalized
(sum to 1).}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
(when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
original vector, and the third column the moving average.
}
\description{
This function returns A matrix: the first column is the position, the second column 
the input vector, and third column moving sum of the given vector. The weight 
argument is optional.
}
\details{
This function can obtain the moving sum efficiently. It serves as somehow a generalized  
version of \code{\link{movMeanUE}}. The difference is that it will not automatically 
normalized the weights vector, \emph{w} argument. \cr
If there is no missing value in \emph{vec}, and \emph{w} is normalized, which means
the sum of all elements is \emph{1}, this function will return a moving average.
For matrix details, please refer to details of \code{movMeanUE}.
}
\section{Functions}{
\itemize{
\item \code{movSumUEr}: An function equivalent to \code{movSumUE(..., align = "right")}
}}

\examples{
movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), 2)
movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE)
movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
sizeD = TRUE)
movSumUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), w = c(0, 1),  n = 2, 
ss = 3, na_rm = TRUE, align = "right")
movSumUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, 
na_rm = TRUE, sizeD = TRUE, align = "right")
movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9),  n = 2, ss = 3, 
na_rm = TRUE)
movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
sizeD = TRUE)
}
