# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name movCount
#' @title Moving Count
#' 
#' 
#' @description This function returns a moving count of the given vector. 
#'
#'
#' @param vec A numeric vector.
#' @param n An integer: moving window size, with 1 as default
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points 
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details This function counts the number of non-missing values for each moving window. It is 
#' especially designed for \emph{vec} vector with missing values. Otherwise, it will return a trivial 
#' vector with all elements \emph{n}.
#' 
#' 
#' @return This function returns a vector whose length is the same as that of \emph{vec} or is 
#'\code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
#' length of \eqn{vec}.
#' 
#' @examples
#' movCount(c(1, 4, 3, NA, 8), 2, na_rm = TRUE)
#' movCount(c(1, 4, 3, NA, 8), 2, na_rm = TRUE, align = 'right')
#' movCountr(c(1, 4, 3, NA, 8), 2, na_rm = TRUE)
#' movCount(c(1, 4, 3, NA, NA), 2, na_rm = TRUE)
#' @export
movCount <- function(vec, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movCount`, vec, n, ss, na_rm, sizeD, align)
}

#' @describeIn movCount An function equivalent to \code{movCount(..., align = "right")}
#' @export
movCountr <- function(vec, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movCountr`, vec, n, ss, na_rm, sizeD)
}

#' @name movCountUE
#' @title Weighted Simple Moving Count for Unevenly Spaced Time Series 
#' 
#' 
#' @description This function returns A matrix: the first column is the position, the second column 
#' the input vector, and third column Moving Count of the given vector. The weight 
#' argument is optional. 
#'
#' @param vec A numeric vector.
#' @param pos A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
#' N.B. We use integers to represent the (relative) positions of every point.
#' 
#' @param n An integer: moving window size, with 1 as default
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' @details This function counts the number of non-missing values for each moving window. It is 
#' especially designed for \emph{vec} vector with missing values. Otherwise, it will return a trivial 
#' vector with all elements \emph{n}. \cr
#' This function is more helpful than \code{movCount}, as we would have missing values for an Unevenly 
#' Spaced Time Series. \cr
#' For matrix details, please refer to details of \code{movMeanUE}.
#'  
#' 
#' @return This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
#' of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
#' (when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
#' original vector, and the third column the moving average. 
#' 
#' 
#' @examples
#' movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), 2)
#' movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE)
#' movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
#' sizeD = TRUE)
#' movCountUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, 
#' ss = 3, na_rm = TRUE, align = "right")
#' movCountUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, 
#' na_rm = TRUE, sizeD = TRUE, align = "right")
#' movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9),  n = 2, ss = 3, 
#' na_rm = TRUE)
#' movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
#' sizeD = TRUE)
#' @export
movCountUE <- function(vec, pos, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movCountUE`, vec, pos, n, ss, na_rm, sizeD, align)
}

#' @describeIn movCountUE An function equivalent to \code{movCountUE(..., align = "right")}
#' @export
movCountUEr <- function(vec, pos, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movCountUEr`, vec, pos, n, ss, na_rm, sizeD)
}

#' @name movEmean
#' @title Basic Exponential Moving Mean 
#' 
#' 
#' @description This function returns a basic exponential moving average (EMA) of the given vector.
#'
#'
#' @param vec A numeric vector.
#' @param n An integer: moving window size, with \eqn{1} as default
#' @param smFac A number: smoothing factor, with default \eqn{2/(n+1)},  see \strong{details} below. 
#' 
#' 
#' @details
#' This function makes fairly efficient the computation of EMA, which dubbed as basic 
#' exponential smoothing, the same section of \url{https://en.wikipedia.org/wiki/Exponential_smoothing}.
#' It provides an access to define \emph{smFac} yourself, i.e the smoothing factor, 
#' whose default is \eqn{2/(n+1)}.
#' 
#' 
#' @return This function returns a vector whose length is the same as that of \emph{vec}.
#' 
#' 
#' @examples
#' movEmean(c(1, 4, 3, 6, 8), 2, smFac = 1/3)
#' movEmean(c(1, 4, 3, 6, 8), 2)
#' @export
movEmean <- function(vec, n = 1L, smFac = NULL) {
    .Call(`_RcppMovStat_movEmean`, vec, n, smFac)
}

#' @name movMean
#' @title Weighted Simple Moving Mean
#' 
#' 
#' @description This function returns a simple moving average of the given vector. The weight 
#' argument is optional. 
#'
#'
#' @param vec A numeric vector.
#' @param n An integer: moving window size, with 1 as default
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param w An optional weight vector of length \emph{n}. It will be automatically normalized
#' (sum to 1). 
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details
#' Despite of Efficient computation, usually 5~6 times faster than the moving average function in 
#' package 'RcppRoll', it is able to handle potential missing values
#' (\emph{NA} or \emph{NaN}) in the \emph{vec}. \cr
#' For instance, the output of the second example is \eqn{NA, NA, 2.200000 3.714286 4.875000}. The 
#' last number \eqn{5.5} is obtained by using re-normalized weight, namely omitting \eqn{0.2}.
#' The weight applied would be \eqn{0.5/(0.5+0.3)} and \eqn{0.3/(0.5+0.3)}. Hence, 
#' \deqn{4.875 = 3 * 0.5/(0.5+0.3) + 8 * 0.3/(0.5+0.3)}
#' 
#' 
#' @return This function returns a vector whose length is the same as that of \emph{vec} or is 
#' \code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
#' length of \eqn{vec}.
#' 
#' 
#' @examples
#' movMean(c(1, 4, 3, NA, 8), 3, align = "right", na_rm = TRUE)
#' movMean(c(1, 4, 3, NA, 8), 3, w = c(0.5, 0.2, 0.3), na_rm = TRUE, align = "right")
#' movMean(c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "right")
#' @export
movMean <- function(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movMean`, vec, n, ss, w, na_rm, sizeD, align)
}

#' @describeIn movMean An function equivalent to \code{movMean(..., align = "right")}
#' @export
movMeanr <- function(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movMeanr`, vec, n, ss, w, na_rm, sizeD)
}

#' @name movMeanUE
#' @title Weighted Simple Moving Mean for Unevenly Spaced Time Series 
#' 
#' 
#' @description This function returns A matrix: the first column is the position, the second column 
#' the input vector, and third column simple moving average of the given vector. The weight 
#' argument is optional. 
#'
#' @param vec A numeric vector.
#' @param pos A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
#' N.B. We use integers to represent the (relative) potions of every point.
#' 
#' @param n An integer: moving window size, with 1 as default
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param w An optional weight vector of length \emph{n}. It will be automatically normalized
#' (sum to 1). 
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details
#' This function is especially designed for Unevenly Spaced Time Series. It is efficient as it inherits the 
#' similar routine of \code{movMean}. \cr
#' The result is kind of tricky. To make it clear, it is written to return a MATRIX. For instance, the 
#' third column of the output of second example is \eqn{NA, 2.5, 4.0, NA, NA, NA, 3.0, 3.0, 8.0}. 
#' 2.5 is the average of 1 and 4, and 4.0 the average of 4. The third column of the output of 
#' third example is the every third element starting from \eqn{n}th number. \cr
#' For how weights, \eqn{w}, work, one can refer to \code{movMean}. 
#' 
#' 
#' @return This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
#' of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
#' (when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
#' original vector, and the third column the moving average. 
#' 
#' 
#' @examples
#' movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), 2)
#' movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE)
#' movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
#' sizeD = TRUE)
#' movMeanUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), w = c(0, 1),  n = 2, 
#' ss = 3, na_rm = TRUE, align = "right")
#' movMeanUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, 
#' na_rm = TRUE, sizeD = TRUE, align = "right")
#' movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9),  n = 2, ss = 3, 
#' na_rm = TRUE)
#' movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
#' sizeD = TRUE)
#' movMeanUE(rnorm(50), pos = sort(sample(1:100, 50, replace = FALSE)),  n = 5, 
#' ss = 10, na_rm = TRUE, align = "right")
#' @export
movMeanUE <- function(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movMeanUE`, vec, pos, n, ss, w, na_rm, sizeD, align)
}

#' @describeIn movMeanUE An function equivalent to \code{movMeanUE(..., align = "right")}
#' @export
movMeanUEr <- function(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movMeanUEr`, vec, pos, n, ss, w, na_rm, sizeD)
}

#' @name movQt
#' @title Moving Quantile(Moving Median, Moving Minimum, Moving Maximum)
#' 
#' 
#' @description This function returns a moving quantile of the given vector. 
#'
#'
#' @param vec A numeric vector.
#' @param n An integer: moving window size, with 1 as default
#' @param prob A number: between \emph{0} and \emph{1}, meaning \emph{prob} quantile
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details
#' Despite of Efficient computation, this function can return different kinds of moving quantile,
#' e.g. moving median(\eqn{prob = 0.5}), moving minimum(\eqn{prob = 0}), 
#' and moving maximum(\eqn{prob = 1}). It can handle potential 
#' missing values(\emph{NA} or \emph{NaN}) in the \emph{vec}. When we move to one specific fragment, missing 
#' values can be removed by setting \eqn{na_rm = TRUERUE}. If all values of this fragment is missing, 
#' it will return \emph{NA}.  \cr
#' In terms of the quantile algorithm, please consult type \emph{7} in function 
#' \code{\link[stats]{quantile}}.
#' 
#' 
#' @return This function returns a vector whose length is the same as that of \emph{vec} or is 
#' \code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
#' length of \eqn{vec}.
#' 
#' @examples
#' movQt(vec = c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "right")
#' movQt(vec = c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, na_rm = TRUE, align = "right")
#' movQt(vec = c(1, 4, 3, NA, NA, NA, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "middle")
#' @export
movQt <- function(vec, n = 1L, prob = .5, ss = 1L, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movQt`, vec, n, prob, ss, na_rm, sizeD, align)
}

#' @describeIn movQt An function equivalent to \code{movQt(..., align = "right")}
#' @export
movQtr <- function(vec, n = 1L, prob = .5, ss = 1L, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movQtr`, vec, n, prob, ss, na_rm, sizeD)
}

#' @name movQtUE
#' @title Moving quantile_UE(Moving Median, Moving Minimum, Moving Maximum)
#' for Unevenly Spaced Time Series 
#' 
#' @description This function returns A matrix: the first column is the position, the second column 
#' the input vector, and third column moving quantile_UE of the given vector. 
#'
#' @param vec A numeric vector.
#' @param pos A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
#' N.B. We use integers to represent the (relative) positions of every point.
#' 
#' @param n An integer: moving window size, with 1 as default
#' @param prob A number: between \emph{0} and \emph{1}, meaning \emph{prob} quantile_UE
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details
#' This function is especially designed for Unevenly Spaced Time Series. It is efficient as it inherits the 
#' similar routine of \code{movQt}. \cr
#' The result is kind of tricky. To make it clear, it is written to return a MATRIX. For instance, the 
#' third column of the output of second example is \eqn{2.5, NA, NA, NA, NA, NA, 3.0, NA, NA}. 
#' 2.5 is the median of 1 and 4, and 4.0 the average of 4. The third column of the output of 
#' third example is the every third element starting from \eqn{n}th number. \cr
#' For how weights, \eqn{w}, work, one can refer to \code{movQt}. 
#' 
#' 
#' @return This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
#' of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
#' (when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
#' original vector, and the third column the moving average. 
#' 
#' @examples
#' movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE)
#' movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, sizeD = TRUE)
#' movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE, align = "middle")
#' movQtUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, sizeD = TRUE,
#'  align = "right")
#' @export
movQtUE <- function(vec, pos, n = 1L, prob = .5, ss = 1L, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movQtUE`, vec, pos, n, prob, ss, na_rm, sizeD, align)
}

#' @describeIn movQtUE An function equivalent to \code{movQtUE(..., align = "right")}
#' @export
movQtUEr <- function(vec, pos, n = 1L, prob = .5, ss = 1L, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movQtUEr`, vec, pos, n, prob, ss, na_rm, sizeD)
}

#' @name movSum
#' @title Weighted Simple Moving Sum
#' 
#' 
#' @description This function returns a simple moving sum of the given vector. The weight 
#' argument is optional. 
#'
#'
#' @param vec A numeric vector.
#' @param n An integer: moving window size, with 1 as default
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param w An optional weight vector of length \emph{n}. 
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details
#' This function can obtain the moving sum efficiently. It serves as somehow a generalized  
#' version of \code{\link{movMean}}. The difference is that it will not automatically 
#' normalized the weights vector, \emph{w} argument. \cr
#' If there is no missing value in \emph{vec}, and \emph{w} is normalized, which means
#' the sum of all elements is \emph{1}, this function will return a moving average.    
#' 
#' 
#' @return This function returns a vector whose length is the same as that of \emph{vec} or is 
#' \code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
#' length of \eqn{vec}.
#' 
#' @examples
#' movSum(c(1, 4, 3, NA, 8), 3, align = "right", na_rm = TRUE)
#' movSum(c(1, 4, 3, NA, 8), 3, w = c(0.5, 0.2, 0.3), na_rm = TRUE, align = "right")
#' movSum(c(1, 4, 3, NA, 8, 4, 5, 9, 6, 0), n = 3, ss = 4, na_rm = TRUE, align = "right")
#' @export
movSum <- function(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movSum`, vec, n, ss, w, na_rm, sizeD, align)
}

#' @describeIn movSum An function equivalent to \code{movMean(..., align = "right")}
#' @export
movSumr <- function(vec, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movSumr`, vec, n, ss, w, na_rm, sizeD)
}

#' @name movSumUE
#' @title Weighted Simple Moving Sum for Unevenly Spaced Time Series 
#' 
#' 
#' @description This function returns A matrix: the first column is the position, the second column 
#' the input vector, and third column moving sum of the given vector. The weight 
#' argument is optional. 
#'
#' @param vec A numeric vector.
#' @param pos A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
#' N.B. We use integers to represent the (relative) positions of every point.
#' 
#' @param n An integer: moving window size, with 1 as default
#' @param ss An integer: step size, only calculating at points with an equal distance \emph{ss}.
#' Namely, there are \emph{ss-1} number between each two 'consecutive' points    
#' @param w An optional weight vector of length \emph{n}. It will be automatically normalized
#' (sum to 1). 
#' @param na_rm logical. Should missing values (including NaN) be removed?
#' @param sizeD logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
#' smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output. 
#' @param align A string denotes how to align the moving average, three options: 
#' "left", "middle", "right"
#' 
#' 
#' @details
#' This function can obtain the moving sum efficiently. It serves as somehow a generalized  
#' version of \code{\link{movMeanUE}}. The difference is that it will not automatically 
#' normalized the weights vector, \emph{w} argument. \cr
#' If there is no missing value in \emph{vec}, and \emph{w} is normalized, which means
#' the sum of all elements is \emph{1}, this function will return a moving average.
#' For matrix details, please refer to details of \code{movMeanUE}.
#'  
#' 
#' @return This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
#' of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
#' (when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
#' original vector, and the third column the moving average. 
#' 
#' 
#' @examples
#' movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), 2)
#' movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE)
#' movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
#' sizeD = TRUE)
#' movSumUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), w = c(0, 1),  n = 2, 
#' ss = 3, na_rm = TRUE, align = "right")
#' movSumUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, 
#' na_rm = TRUE, sizeD = TRUE, align = "right")
#' movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9),  n = 2, ss = 3, 
#' na_rm = TRUE)
#' movSumUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
#' sizeD = TRUE)
#' @export
movSumUE <- function(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE, align = "left") {
    .Call(`_RcppMovStat_movSumUE`, vec, pos, n, ss, w, na_rm, sizeD, align)
}

#' @describeIn movSumUE An function equivalent to \code{movSumUE(..., align = "right")}
#' @export
movSumUEr <- function(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE, sizeD = FALSE) {
    .Call(`_RcppMovStat_movSumUEr`, vec, pos, n, ss, w, na_rm, sizeD)
}

