\name{initHMM}
\alias{initHMM}

\title{
Random Initialization for a Hidden Markov Model with Categoric (Labeled) Emissions
}

\description{
Function used to generate a hidden Markov model with random parameters. The code for the methods with continuous values or discrete data can be viewed in \code{"\link{initGHMM}"} and \code{"\link{initPHMM}"}, respectively.  
}

\usage{
initHMM(n, m)
}

\arguments{
  \item{n}{it sets the number of hidden states to use.}
  \item{m}{it sets the number of possible values generated by the hidden states.}
}

\value{
A \code{"\link{list}"} that contains all the required values to especify the model.
\item{Model}{it especifies that the observed values are modeled by a multinomial distribution.}
\item{StateNames}{the set of hidden state names.}
\item{ObservationNames}{the set of possible observed values.}
\item{A}{the transition matrix.} 
\item{B}{the emission matrix.} 
\item{Pi}{the initial probability vector.}
}

\references{
Cited references are listed on the \link{RcppHMM} manual page.
}

\examples{
n <- 2
m <- 2
model <- initHMM(n,m)
print(model)
}

\keyword{initialization}
