//=================================================================================================
/*!
//  \file blaze/util/Constraints.h
//  \brief Header file for compile time constraints
//
//  Copyright (C) 2013 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_UTIL_CONSTRAINTS_H_
#define _BLAZE_UTIL_CONSTRAINTS_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/util/constraints/Arithmetic.h>
#include <blaze/util/constraints/Array.h>
#include <blaze/util/constraints/BaseOf.h>
#include <blaze/util/constraints/Boolean.h>
#include <blaze/util/constraints/Builtin.h>
#include <blaze/util/constraints/Class.h>
#include <blaze/util/constraints/Comparable.h>
#include <blaze/util/constraints/Complex.h>
#include <blaze/util/constraints/ComplexDouble.h>
#include <blaze/util/constraints/ComplexFloat.h>
#include <blaze/util/constraints/Const.h>
#include <blaze/util/constraints/Convertible.h>
#include <blaze/util/constraints/DerivedFrom.h>
#include <blaze/util/constraints/Double.h>
#include <blaze/util/constraints/Empty.h>
#include <blaze/util/constraints/Float.h>
#include <blaze/util/constraints/FloatingPoint.h>
#include <blaze/util/constraints/Integer.h>
#include <blaze/util/constraints/Integral.h>
#include <blaze/util/constraints/LongDouble.h>
#include <blaze/util/constraints/Numeric.h>
#include <blaze/util/constraints/Object.h>
#include <blaze/util/constraints/Pod.h>
#include <blaze/util/constraints/Pointer.h>
#include <blaze/util/constraints/Rank.h>
#include <blaze/util/constraints/Reference.h>
#include <blaze/util/constraints/SameSize.h>
#include <blaze/util/constraints/SameType.h>
#include <blaze/util/constraints/Signed.h>
#include <blaze/util/constraints/Size.h>
#include <blaze/util/constraints/Subscriptable.h>
#include <blaze/util/constraints/TypeRestriction.h>
#include <blaze/util/constraints/Union.h>
#include <blaze/util/constraints/Unsigned.h>
#include <blaze/util/constraints/Valid.h>
#include <blaze/util/constraints/Vectorizable.h>
#include <blaze/util/constraints/Void.h>
#include <blaze/util/constraints/Volatile.h>

#endif
