% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_unflatten.R
\name{cdb_unflatten}
\alias{cdb_unflatten}
\title{Reconstitute a flattened COM(P)ADRE database (created by cdb_flatten) as a
CompadreDB object}
\usage{
cdb_unflatten(db)
}
\arguments{
\item{db}{A data frame created with \link{cdb_flatten}, with columns for
matrices \code{matA}, \code{matU}, \code{matF}, \code{matC}, and vectors
\code{MatrixClassAuthor}, and \code{MatrixClassOrganized} in string
representation.}
}
\value{
A CompadreDB object. Because version details are lost when the
  database is flattened, the \code{Version} and \code{DateCreated} elements
  of the returned CompadreDB object will be \code{NA}.
}
\description{
Converts a flattened COM(P)ADRE database (created by \link{cdb_flatten}) back
to the CompadreDB class
}
\examples{
CompadreFlat <- cdb_flatten(Compadre) # flatten
Compadre2 <- cdb_unflatten(CompadreFlat) # reconstitute

}
\seealso{
\link{cdb_flatten} \link{string_representation}

Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{string_representation}}
}
\author{
Patrick M. Barks <patrick.barks@gmail.com>
}
\concept{data management}
