% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semisupervised.R
\name{computeSemiSupervised}
\alias{computeSemiSupervised}
\title{Semi-supervised clustering}
\usage{
computeSemiSupervised(data.sample, ML, CNL, K = 0, kmax = 20,
  method.name = "Constrained_KM", maxIter = 2, pca = F,
  pca.nb.dims = 0, spec = F, use.sampling = FALSE,
  sampling.size.max = 0, scaling = F,
  RclusTool.env = initParameters(), echo = T)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{ML}{list of ML (must-link) constrained pairs (as row.names of features).}

\item{CNL}{list of CNL (cannot-link) constrained pairs (as row.names of features).}

\item{K}{number of clusters. If K=0 (default), this number is automatically computed thanks to the Elbow method.}

\item{kmax}{maximum number of clusters.}

\item{method.name}{character vector specifying the constrained algorithm to use. Must be 'Constrained_KM' (default) or 'Constrained_SC' (Constrained Spectral Clustering).}

\item{maxIter}{number of iterations for SemiSupervised algorithm}

\item{pca}{boolean: if TRUE, Principal Components Analysis is applied to reduce the data space.}

\item{pca.nb.dims}{number of principal components kept. If pca.nb.dims=0, this number is computed automatically.}

\item{spec}{boolean: if TRUE, spectral embedding is applied to reduce the data space.}

\item{use.sampling}{boolean: if FALSE (default), data sampling is not used.}

\item{sampling.size.max}{numeric: maximal size of the sampling set.}

\item{scaling}{boolean: if TRUE, scaling is applied.}

\item{RclusTool.env}{environment in which data and intermediate results are stored.}

\item{echo}{boolean: if FALSE (default), no description printed in the console.}
}
\value{
The function returns a list containing:
\item{label}{vector of labels.}
\item{summary}{data.frame containing clusters summaries (min, max, sum, average, sd).}
\item{nbItems}{number of observations.}
}
\description{
Perform semi-supervised clustering based on pairwise constraints, dealing with the number of clusters K, automatically or not.
}
\details{
computeSemiSupervised performs semi-supervised clustering based on pairwise constraints, dealing with the number of clusters K, automatically or not
}
\examples{
\donttest{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf, dir.save=tempdir())

pairs.abs <- visualizeSampleClustering(x, selection.mode = "pairs", 
		    profile.mode="whole sample", wait.close=TRUE)

res.ckm <- computeSemiSupervised(x, ML=pairs.abs$ML, CNL=pairs.abs$CNL, K=0)
plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y",
col = res.ckm$label, main = "Constrained K-means clustering")


}

}
\seealso{
\code{\link{computeCKmeans}}, \code{\link{computeCSC}}, \code{\link{KwaySSSC}}
}
