% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSSSC.R
\name{measureConstraintsOk}
\alias{measureConstraintsOk}
\title{Rates of constraints satisfaction}
\usage{
measureConstraintsOk(label, list.ML = list(), list.CNL = list())
}
\arguments{
\item{label}{vector of labels.}

\item{list.ML}{list of ML (must-link) constrained pairs.}

\item{list.CNL}{list of CNL (cannot-link) constrained pairs.}
}
\value{
The function returns a list containing:
\item{ML}{rate of ML (must-link) constraints satisfaction.}
\item{CNL}{rate of CNL (cannot-link) constraints satisfaction.}
}
\description{
Calculate the rates of ML and CNL constraints satisfaction in a clustering result.
}
\details{
measureConstraintsOk returns the rates of constraints satisfaction
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
ML <- list()
ML[[1]] <- c(sel="10",mem="20")
ML[[2]] <- c(sel="60",mem="70")

CNL <- list()
CNL[[1]] <- c(sel="30",mem="80")
CNL[[2]] <- c(sel="90",mem="120")

sim <- computeGaussianSimilarity(dat, 1)
res <- KwaySSSC(sim, K=0, list.ML=ML, list.CNL=CNL)

measureConstraintsOk(res$label, list.ML=ML, list.CNL=CNL)

}
\keyword{internal}
