% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleView.R
\name{visualizeSampleClustering}
\alias{visualizeSampleClustering}
\title{Interactive figure with 2D scatter-plot}
\usage{
visualizeSampleClustering(
  data.sample,
  label = NULL,
  clustering.name = "proposed clustering",
  cluster.summary = NULL,
  RclusTool.env = initParameters(),
  prototypes = NULL,
  profile.mode = "none",
  selection.mode = "none",
  compare.mode = "off",
  pairs = NULL,
  features.mode = "initial",
  wait.close = FALSE
)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{label}{vector of labels.}

\item{clustering.name}{character vector specifying the clustering method used to get labels.}

\item{cluster.summary}{data.frame containing the clusters summaries (as returned by 'clusterSummary').}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}

\item{prototypes}{list containing vectors of prototypes indices.}

\item{profile.mode}{character vector specifying the plot mode of profiles. Must be 'none' (default), 'whole sample', 'cluster i' or 'constrained pairs'.}

\item{selection.mode}{character vector specifying the selection mode of profiles. Must be 'none' (default), 'prototypes' or 'pairs'.}

\item{compare.mode}{character vector specifying the mode of comparison between two clusterings results. Must be 'off' (default) or 'on'.}

\item{pairs}{list of constrained pairs (must-link and cannot-link).}

\item{features.mode}{character vector specifying the plot mode of features (projection in a specific space). Must be 'initial' (default), 'preprocessed', 'pca', 'pca_full' or 'spectral', or prefixed versions ('sampled', 'scaled') of those space names.}

\item{wait.close}{boolean: if FALSE (default), the following steps of the analysis calculations are computed even if the window is not closed.}
}
\value{
prototypes in \code{selection.mode} = "prototypes" mode, pairs in \code{selection.mode} = "pairs" mode.
}
\description{
Open an interactive figure with 2D scatter-plot of all particles with axis choice. Grey color (label=0) is for data to cleaned or to remove in classification process.
}
\details{
visualizeSampleClustering opens an interactive figure with 2D scatter-plot of all particles with axis choice
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

sig <- data.frame(ID=rep(1:150, each=30), SIGNAL=rep(dnorm(seq(-2,2,length=30)),150))
tf2 <- tempfile()
write.table(sig, tf2, sep=",", dec=".")

x <- importSample(file.features=tf1, file.profiles=tf2, dir.save=tempdir())

res <- KmeansQuick(x$features$initial$x, K=3)
new.labels <- formatLabelSample(res$cluster, x)

visualizeSampleClustering(x, label = new.labels, clustering.name="K-means", 
		     profile.mode="whole sample")
 

}
\seealso{
\code{\link{plotProfile}}, \code{\link{plotSampleFeatures}}
}
