% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleView.R
\name{plotProfile}
\alias{plotProfile}
\title{Profile and image plotting}
\usage{
plotProfile(
  profiles,
  profiles.colors = NULL,
  image = NULL,
  curve.names = NULL,
  title = "Some observation",
  sub = "",
  sub.color = NULL,
  image.dir = NULL
)
}
\arguments{
\item{profiles}{matrix of profile data (signals in columns).}

\item{profiles.colors}{vector of colors corresponding to each signal in profile.}

\item{image}{character vector specifying the name (without path) + extension of the associated image (if available).}

\item{curve.names}{vector of character specifying the names of each signal in profile.}

\item{title}{character vector specifying the title of the plot.}

\item{sub}{character vector specifying the subtitle of the plot.}

\item{sub.color}{character vector specifying the color of the subtitle.}

\item{image.dir}{images directory.}
}
\value{
None
}
\description{
Plot the profile and the image (if available) of a particle.
}
\details{
plotProfile plots the profile and the image (if available) of a particle
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 6, sd = 0.3), ncol = 2))
colnames(dat) <- c("x","y")
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

sig <- data.frame(ID=rep(1:150, each=30), SIGNAL=rep(dnorm(seq(-2,2,length=30)),150))
tf2 <- tempfile()
write.table(sig, tf2, sep=",", dec=".")

x <- importSample(file.features=tf1, file.profiles=tf2, dir.save=tempdir())

plotProfile(x$profiles[[1]])
 


}
\seealso{
\code{\link{plotSampleFeatures}}, \code{\link{visualizeSampleClustering}}
}
\keyword{internal}
