% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blpAuthenticate.R
\name{blpAuthenticate}
\alias{blpAuthenticate}
\title{Authenticate Bloomberg API access}
\usage{
blpAuthenticate(uuid, host = "localhost", ip.address,
  con = defaultConnection())
}
\arguments{
\item{uuid}{A character variable with a unique user id token. If this
is missing the function will attempt to connect to bpipe using the connection. It
is assumed that an app_name was set. See blpConnect() for app_name information}

\item{host}{A character variable with a hostname, defaults to 'localhost'}

\item{ip.address}{An optional character variable with an IP address}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function. This is the only required
argument to authenticate a bpipe connection with a appName.
\code{defaultConnection}.}
}
\value{
The returned object should be passed to subsequent data
calls via bdp(), bds(), etc.
}
\description{
This function authenticates against the the Bloomberg API
}
\examples{
\dontrun{
blpConnect(host=blpHost, port=blpPort)
blpid <- blpAuthenticate(uuid=blpUUID, ip=blpIP_address)
bdp("IBM US Equity", "NAME", identity=blpid)
}
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}
