\name{instantiate.metacyc}
\alias{instantiate.metacyc}
\title{
Instantiate MetaCyc generic reaction
}
\description{
Generic reaction is a reaction with at least one compound class. This function gains instance reactions from given generic reaction
}
\usage{
instantiate.metacyc(equation, chemical_table, id_col = "UNIQUE.ID", 
  parent_col = "TYPES", formula_col = "CHEMICAL.FORMULA", smiles_col
  = "SMILES", inchi_col = "INCHI", direction_type = c(" => ", " <=> "))
}
\arguments{
  \item{equation}{
MetaCyc generic reaction equation with MetaCyc ID (not compound name)
}
  \item{chemical_table}{
Chemical table containing UNIQUE.ID, TYPES, CEHEMICAL.FORMULA, SMILES and InChI columns. This table can be generated by parse.metacyc.compound() function
}
  \item{id_col}{
In chemical table, choose the column name which contains chemical ID (usually first column)
}
  \item{parent_col}{
In chemical table, choose the column name which contains parent compound ("TYPES" in MetaCyc)
}
  \item{formula_col}{
In chemical table, choose the column name which contains molecular formula
}
  \item{smiles_col}{
In chemical table, choose the column name which contains SMILES code
}
  \item{inchi_col}{
In chemical table, choose the column name which contains InChI code
}
  \item{direction_type}{
In reaction equation, provide reaction direction charaters. Default is c(" <=> ", " => ")
}
}
\value{
List object containing instance reactions
}
\references{
Bioinformatics (Oxford, England) 2012, 28(3):388-396. Construction and completion of flux balance models from pathway databases \cr
O'Boyle NM, Banck M, James CA, Morley C, Vandermeersch T, Hutchison GR. Open Babel: An open chemical toolbox. J Cheminform. 2011 Oct 7;3:33. doi: 10.1186/1758-2946-3-33. PubMed PMID: 21982300; PubMed Central PMCID: PMC3198950.
}
\author{
Byoungnam Min <mbnmbn00@gmail.com>, Byeonghyuk Park, Kyoung Heon Kim and In-Geol Choi 
}
\seealso{
\code{\link{parse.metacyc.compound}}
}
\examples{
# You need to load 'ChemmineOB' package before running this function.

data(example) # Load example rdata

Mc = example$metacyc.c
Mg = example$metacyc_generic$equation

names(Mc)       # Check chemical table columns

# Instantiate: Not run
#instanceM = instantiate.metacyc(Mg, Mc, id_col = "UNIQUE.ID", 
#  parent_col = "TYPES", formula_col = "CHEMICAL.FORMULA", smiles_col
#  = "SMILES", inchi_col = "INCHI", direction_type = c(" => ", " <=> "))

#print(instanceM)
}
\keyword{ MetaCyc }
