\name{RSctr}
\alias{RSctr}
\title{Control Object}
\description{
  The object of class \code{RSctr} represents the control parameter
  specification for the sampling function \code{\link{rsampler}}.
}
\value{
   A legitimate \code{\link{RSctr}} object is a list with components
  \item{burn_in}{
      the number of matrices to be sampled to
      come close to a stationary distribution.
      }
  \item{n_eff}{
      the number of effective matrices, i.e.,
      the number of matrices
      to be generated by the sampling function \code{\link{rsampler}}.
      }
  \item{step}{
      controls the number number of void matrices generated in the the burn in
      process and when effective matrices are generated (see note
      in \code{\link{rsctrl}}). }
  \item{seed}{
      is the indicator for the seed of the random number generator.
      If the value of seed at equals zero, a seed is generated
      by the sampling function \code{\link{rsampler}}
      }
  \item{tfixed}{
      \code{TRUE} or \code{FALSE}. \code{tfixed = TRUE} has no effect
      if the input matrix is not quadratic,
      i.e., all matrix elements are considered free (unrestricted).
      If the input matrix is quadratic, and \code{tfixed = TRUE},
      the main diagonal of the matrix is considered as fixed.
      }
}
\section{Generation}{
      This object is returned from function
      \code{rsctrl}.
}
\section{Methods}{
      This class has a method for the generic \code{summary}
      function.
}
\seealso{\code{\link{rsctrl}} }
\keyword{misc}
