% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{plot.acmap}
\alias{plot.acmap}
\title{Plot an antigenic map}
\usage{
\method{plot}{acmap}(
  x,
  optimization_number = 1,
  xlim = NULL,
  ylim = NULL,
  plot_ags = TRUE,
  plot_sr = TRUE,
  plot_labels = FALSE,
  plot_blobs = TRUE,
  point_opacity = "automatic",
  show_procrustes = TRUE,
  show_error_lines = FALSE,
  plot_stress = FALSE,
  indicate_outliers = "arrowheads",
  grid.col = "grey90",
  grid.margin.col = "grey50",
  outlier.arrow.col = grid.col,
  fill.alpha = 0.8,
  outline.alpha = 0.8,
  procrustes.lwd = 2,
  procrustes.col = "black",
  procrustes.arr.type = "triangle",
  procrustes.arr.length = 0.2,
  procrustes.arr.width = 0.15,
  label.offset = 0,
  padding = 1,
  cex = 1,
  margins = rep(0.5, 4),
  ...
)
}
\arguments{
\item{x}{The acmap to plot}

\item{optimization_number}{The optimization number to plot}

\item{xlim}{optional x axis limits}

\item{ylim}{optional y axis limits}

\item{plot_ags}{logical, should antigens be plotted}

\item{plot_sr}{logical, should antigens be plotted}

\item{plot_labels}{should point labels be plotted, can be true, false or
"antigens" or "sera"}

\item{plot_blobs}{logical, should stress blobs be plotted if present}

\item{point_opacity}{Either "automatic" or "fixed". "fixed" fixes point
opacity to match those in \code{ptFill()} and \code{ptOutline()} and will not be
altered in procrustes plots or by the fill.alpha and outline.alpha
parameters.}

\item{show_procrustes}{logical, should procrustes lines be shown, if present}

\item{show_error_lines}{logical, should error lines be drawn}

\item{plot_stress}{logical, should map stress be plotted in lower left corner}

\item{indicate_outliers}{how should points outside the plotting region be
indicated, either FALSE, for not shown, "arrowheads" for small arrowheads
like in the viewer, or "arrows" for arrows pointing from the edge of the
plot margin, default is "arrowheads".}

\item{grid.col}{grid line color}

\item{grid.margin.col}{grid margin color}

\item{outlier.arrow.col}{outlier arrow color}

\item{fill.alpha}{alpha for point fill}

\item{outline.alpha}{alpha for point outline}

\item{procrustes.lwd}{procrustes arrow line width}

\item{procrustes.col}{procrustes arrow color}

\item{procrustes.arr.type}{procrustes arrow type (see \code{shape::Arrows()})}

\item{procrustes.arr.length}{procrustes arrow length (see \code{shape::Arrows()})}

\item{procrustes.arr.width}{procrustes arrow width (see \code{shape::Arrows()})}

\item{label.offset}{amount by which any point labels should be offset from
point coordinates in fractions of a character width}

\item{padding}{padding at limits of the antigenic map, ignored if xlim or
ylim set explicitly}

\item{cex}{point size expansion factor}

\item{margins}{margins in inches for the plot, use \code{NULL} for default margins from \code{par("mar")}}

\item{...}{additional arguments, not used}
}
\value{
Called for the side effect of plotting the map but invisibly
returns the map object.
}
\description{
Method for plotting an antigenic map in two dimensions
}
\seealso{
Other functions to view maps: 
\code{\link{RacViewer.options}()},
\code{\link{RacViewer}()},
\code{\link{export_viewer}()},
\code{\link{ggplot.acmap}()},
\code{\link{mapGadget}()},
\code{\link{setLegend}()},
\code{\link{view.acmap}()},
\code{\link{view.default}()},
\code{\link{view}()}
}
\concept{functions to view maps}
