% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{pseudoTime}
\alias{pseudoTime}
\title{Extract pseudo-time order of cells along a trajectory}
\usage{
pseudoTime(
  object,
  set,
  m = NULL,
  useSlingshot = TRUE,
  map = "umap",
  x = NULL,
  n_neighbors = 15,
  metric = "euclidean",
  n_epochs = 200,
  min_dist = 0.1,
  local_connectivity = 1,
  spread = 1,
  initial_cmd = TRUE,
  perplexity = 30,
  rseed = 15555,
  ...
)
}
\arguments{
\item{object}{\pkg{RaceID} \code{SCseq} object.}

\item{set}{Set of valid ordered cluster numbers (in \code{object@cpart}) defining the trajectory for which the pseudo-temporal order of cells should be computed computed. Only clusters on a single, linear trajectory should be given.}

\item{m}{Existing dimensional reduction representation of RaceID object. Either \code{"fr"}, \code{"tsne"} or \code{"umap"}. Default is NULL and dimensional reduction representation is computed for all cells in \code{set}.}

\item{useSlingshot}{logical. If \code{TRUE} and the \pkg{slingshot} package is available, trajectory inference will be done using slingshot. If \code{FALSE}, inference will be done by principal curve analysis using the \pkg{princurve} package. Default is \code{TRUE}.}

\item{map}{Either \code{"tsne"} or \code{"umap"}. If \code{m} is NULL this argument determines the algorithm (UMAP or t-SNE) for computing the dimensional reduction representation of all cells \code{set} used for pseudo-temporal ordering by the \code{Bioconductor} package \code{slingshot}. Default is \code{"umap"}.}

\item{x}{Optional feature matrix, which will be directly used for computation of the dimensional reduction representation. Default is NULL and \code{object@dimRed$x} is used, unless empty. In this case, \code{getfdata(object)} is used.}

\item{n_neighbors}{Umap parameter (used if \code{map="umap"} and \code{m=NULL}). See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 15.}

\item{metric}{Umap parameter (used if \code{map="umap"} and \code{m=NULL}). See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is "euclidean".}

\item{n_epochs}{Umap parameter (used if \code{map="umap"} and \code{m=NULL}). See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 200.}

\item{min_dist}{Umap parameter (used if \code{map="umap"} and \code{m=NULL}). See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 0.1.}

\item{local_connectivity}{Umap parameter (used if \code{map="umap"} and \code{m=NULL}). See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 1.}

\item{spread}{Umap parameter (used if \code{map="umap"} and \code{m=NULL}). See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 1.}

\item{initial_cmd}{logical. t-SNE parameter (used if \code{map="tsne"} and \code{m=NULL}). If \code{TRUE}, then the t-SNE map computation is initialized with a configuration obtained by classical
multidimensional scaling. Default is \code{TRUE}.}

\item{perplexity}{Positive number. t-SNE parameter (used if \code{map="tsne"} and \code{m=NULL}). Perplexity of the t-SNE map. Default is \code{30}.}

\item{rseed}{Integer number. Random seed to enforce reproducible dimensional reduction computation.}

\item{...}{Additional arguments to be passed to the \code{getCurves} function of the \pkg{slingshot} package.}
}
\value{
List object of six components:
\item{pt}{Vector of pseudo-time value obtained by \pkg{slingshot}.}
\item{ord}{Vector of cells in \code{set} ordered by pseudo-time, starting with the first cluster in \code{set}.}
\item{set}{Vector of cluster numbers defining the trajectory used for pseudo-time inference.}
\item{part}{Vector of cluster numbers of all cells in \code{set}.}
\item{rd}{Two-dimensional matrix with x- and y-coordinates of dimensional reduction representation used for \code{slingshot}.}
\item{sls}{\code{slingshot} data object.}
}
\description{
Extract pseudo-time order of cells along a trajectory defined by a set of clusters using the \pkg{slingshot} algorithm. If the \pkg{slingshot} package is unavailable, the function falls back to inference by principal curve analysis using the \pkg{princurve} package.
}
